/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import org.apache.jetspeed.tools.deploy.JetspeedWebApplicationRewriter;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;

class JetspeedWebApplicationRewriter2_4
extends JetspeedWebApplicationRewriter {
    public static final String JETSPEED_SERVLET_XPATH = "/js:web-app/js:servlet/js:servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String JETSPEED_SERVLET_MAPPING_XPATH = "/js:web-app/js:servlet-mapping/js:servlet-name[contains(child::text(), \"JetspeedContainer\")]";
    public static final String JSP_CONFIG_XPATH = "/js:web-app/js:jsp-config";
    public static final String PORTLET_TAGLIB_XPATH = "/js:web-app/js:jsp-config/js:taglib/js:taglib-uri[contains(child::text(), \"http://java.sun.com/portlet\")]";
    protected static final String[] ELEMENTS_BEFORE_SERVLET = new String[]{"description", "display-name", "icon", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet"};
    protected static final String[] ELEMENTS_BEFORE_SERVLET_MAPPING = new String[]{"description", "display-name", "icon", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping"};
    protected static final String[] ELEMENTS_BEFORE_JSP_CONFIG = new String[]{"description", "display-name", "icon", "distributable", "context-param", "filter", "filter-mapping", "listener", "servlet", "servlet-mapping", "session-config", "mime-mapping", "welcome-file-list", "error-page", "jsp-config"};
    protected static final String[] ELEMENTS_BEFORE_TAGLIB_MAPPING = new String[]{"taglib"};

    public JetspeedWebApplicationRewriter2_4(Document doc, String portletApplication) {
        super(doc, portletApplication);
    }

    public JetspeedWebApplicationRewriter2_4(Document doc) {
        super(doc);
    }

    protected String getJetspeedServletXPath() {
        return JETSPEED_SERVLET_XPATH;
    }

    protected String getJetspeedServletMappingXPath() {
        return JETSPEED_SERVLET_MAPPING_XPATH;
    }

    protected String getPortletTagLibXPath() {
        return PORTLET_TAGLIB_XPATH;
    }

    protected void insertJetspeedServlet(Element root) throws Exception {
        Namespace namespace = root.getNamespace();
        Element jetspeedServletElement = new Element("servlet", namespace);
        Element servletName = new Element("servlet-name", namespace).addContent("JetspeedContainer");
        Element servletDspName = new Element("display-name", namespace).addContent("Jetspeed Container");
        Element servletDesc = new Element("description", namespace).addContent("MVC Servlet for Jetspeed Portlet Applications");
        Element servletClass = new Element("servlet-class", namespace).addContent("org.apache.jetspeed.container.JetspeedContainerServlet");
        jetspeedServletElement.addContent((Content)servletDesc);
        jetspeedServletElement.addContent((Content)servletDspName);
        jetspeedServletElement.addContent((Content)servletName);
        jetspeedServletElement.addContent((Content)servletClass);
        this.insertContextNameParam(jetspeedServletElement);
        this.insertLoadOnStartup(jetspeedServletElement);
        this.insertElementCorrectly(root, jetspeedServletElement, ELEMENTS_BEFORE_SERVLET);
    }

    protected void insertJetspeedServletMapping(Element root) throws Exception {
        Namespace namespace = root.getNamespace();
        Element jetspeedServletMappingElement = new Element("servlet-mapping", namespace);
        Element servletMapName = new Element("servlet-name", namespace).addContent("JetspeedContainer");
        Element servletUrlPattern = new Element("url-pattern", namespace).addContent("/container/*");
        jetspeedServletMappingElement.addContent((Content)servletMapName);
        jetspeedServletMappingElement.addContent((Content)servletUrlPattern);
        this.insertElementCorrectly(root, jetspeedServletMappingElement, ELEMENTS_BEFORE_SERVLET_MAPPING);
    }

    protected void insertPortletTagLib(Element root) throws Exception {
        Namespace namespace = root.getNamespace();
        Element jspConfig = (Element)this.getXPath(JSP_CONFIG_XPATH).selectSingleNode((Object)root.getDocument());
        if (jspConfig == null) {
            jspConfig = new Element("jsp-config", namespace);
            this.insertElementCorrectly(root, jspConfig, ELEMENTS_BEFORE_JSP_CONFIG);
        }
        Element taglib = new Element("taglib", namespace);
        Element taguri = new Element("taglib-uri", namespace).addContent("http://java.sun.com/portlet");
        Element taglocation = new Element("taglib-location", namespace).addContent("/WEB-INF/tld/portlet.tld");
        taglib.addContent((Content)taguri);
        taglib.addContent((Content)taglocation);
        this.insertElementCorrectly(jspConfig, taglib, ELEMENTS_BEFORE_TAGLIB_MAPPING);
    }
}

