/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.tools.deploy;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.xpath.XPath;

public abstract class JetspeedWebApplicationRewriter {
    public static final String JETSPEED_CONTAINER = "JetspeedContainer";
    public static final String JETSPEED_SERVLET_CLASS = "org.apache.jetspeed.container.JetspeedContainerServlet";
    public static final String JETSPEED_SERVLET_DISPLAY_NAME = "Jetspeed Container";
    public static final String JETSPEED_SERVLET_DESCRIPTION = "MVC Servlet for Jetspeed Portlet Applications";
    public static final String NAMESPACE_PREFIX = "js";
    protected static final String WEB_XML_PATH = "WEB-INF/web.xml";
    private Document document;
    private String portletApplication;
    private boolean changed = false;
    private boolean portletTaglibAdded = false;

    public JetspeedWebApplicationRewriter(Document doc, String portletApplication) {
        this.document = doc;
        this.portletApplication = portletApplication;
    }

    public JetspeedWebApplicationRewriter(Document doc) {
        this.document = doc;
    }

    public void processWebXML() throws Exception {
        try {
            Element root = this.document.getRootElement();
            Object jetspeedServlet = this.getXPath(this.getJetspeedServletXPath()).selectSingleNode((Object)this.document);
            Object jetspeedServletMapping = this.getXPath(this.getJetspeedServletMappingXPath()).selectSingleNode((Object)this.document);
            Object portletTaglib = this.getXPath(this.getPortletTagLibXPath()).selectSingleNode((Object)this.document);
            if (!this.document.hasRootElement()) {
                root = new Element("web-app");
                this.document.setRootElement(root);
            }
            if (jetspeedServlet == null) {
                this.insertJetspeedServlet(root);
                this.changed = true;
            } else if (jetspeedServlet instanceof Element) {
                Parent jetspeedServletElement = ((Element)jetspeedServlet).getParent();
                if (null == this.getXPath("js:init-param/js:param-name[contains(child::text(), \"contextName\")]").selectSingleNode((Object)jetspeedServletElement)) {
                    this.insertContextNameParam((Element)jetspeedServletElement);
                }
                if (null == this.getXPath("js:load-on-startup").selectSingleNode((Object)jetspeedServletElement)) {
                    this.insertLoadOnStartup((Element)jetspeedServletElement);
                }
            }
            if (jetspeedServletMapping == null) {
                this.insertJetspeedServletMapping(root);
                this.changed = true;
            }
            if (portletTaglib == null) {
                this.insertPortletTagLib(root);
                this.changed = true;
                this.portletTaglibAdded = true;
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to process web.xml for infusion " + e.toString(), e);
        }
    }

    protected void insertContextNameParam(Element jetspeedServletElement) {
        Namespace namespace = jetspeedServletElement.getNamespace();
        Element param2Name = new Element("param-name", namespace).addContent("contextName");
        Element param2Value = new Element("param-value", namespace).addContent(this.portletApplication);
        Element init2Param = new Element("init-param", namespace);
        init2Param.addContent((Content)param2Name);
        init2Param.addContent((Content)param2Value);
        jetspeedServletElement.addContent((Content)init2Param);
    }

    protected void insertLoadOnStartup(Element jetspeedServletElement) {
        Namespace namespace = jetspeedServletElement.getNamespace();
        Element loadOnStartup = new Element("load-on-startup", namespace).addContent("0");
        jetspeedServletElement.addContent((Content)loadOnStartup);
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void insertElementCorrectly(Element root, Element toInsert, String[] elementsBefore) throws Exception {
        List allChildren = root.getChildren();
        List<String> elementsBeforeList = Arrays.asList(elementsBefore);
        toInsert.detach();
        int insertAfter = 0;
        int count = 0;
        for (int i = 0; i < allChildren.size(); ++i) {
            Element element = (Element)allChildren.get(i);
            if (elementsBeforeList.contains(element.getName())) {
                insertAfter = root.indexOf((Content)element);
            }
            ++count;
        }
        insertAfter = count == 0 ? 0 : insertAfter + 1;
        try {
            root.addContent(insertAfter, (Content)toInsert);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            root.addContent((Content)toInsert);
        }
    }

    public boolean isPortletTaglibAdded() {
        return this.portletTaglibAdded;
    }

    protected XPath getXPath(String path) throws JDOMException {
        XPath xpath = XPath.newInstance((String)path);
        Element root = this.document.getRootElement();
        if (root != null && StringUtils.isNotEmpty((String)root.getNamespaceURI())) {
            xpath.addNamespace(NAMESPACE_PREFIX, root.getNamespaceURI());
        }
        return xpath;
    }

    protected abstract String getJetspeedServletXPath();

    protected abstract String getJetspeedServletMappingXPath();

    protected abstract String getPortletTagLibXPath();

    protected abstract void insertJetspeedServlet(Element var1) throws Exception;

    protected abstract void insertJetspeedServletMapping(Element var1) throws Exception;

    protected abstract void insertPortletTagLib(Element var1) throws Exception;
}

