/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.jetspeed.util.ServletRequestThreadLocalCleanupCallback;

public class JSSubject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156057L;
    static ThreadLocal threadLocal = new ThreadLocal();

    private static void setSubject(Subject subject) {
        if (threadLocal.get() == null && subject != null) {
            new ServletRequestThreadLocalCleanupCallback(threadLocal);
        }
        threadLocal.set(subject);
    }

    public static Subject getSubject(AccessControlContext acc) {
        Subject s = null;
        try {
            s = (Subject)threadLocal.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s == null) {
            return Subject.getSubject(acc);
        }
        return s;
    }

    public static Object doAs(Subject subject1, PrivilegedAction action) {
        Subject subject = subject1;
        if (subject == null) {
            subject = JSSubject.getSubject(null);
        }
        JSSubject.setSubject(subject);
        return Subject.doAs(subject, action);
    }

    public static Object doAs(Subject subject1, PrivilegedExceptionAction action) throws PrivilegedActionException {
        Subject subject = subject1;
        if (subject == null) {
            subject = JSSubject.getSubject(null);
        }
        JSSubject.setSubject(subject);
        if (subject != null) {
            return Subject.doAs(subject, action);
        }
        return Subject.doAs(subject, action);
    }

    public static Object doAsPrivileged(Subject subject1, PrivilegedAction action, AccessControlContext acc) {
        Subject subject = subject1;
        if (subject == null) {
            subject = JSSubject.getSubject(acc);
        }
        JSSubject.setSubject(subject);
        if (subject != null) {
            return Subject.doAsPrivileged(subject, action, acc);
        }
        return Subject.doAsPrivileged(subject, action, acc);
    }

    public static Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        Subject s = subject;
        if (s == null) {
            s = JSSubject.getSubject(acc);
        }
        JSSubject.setSubject(s);
        if (s != null) {
            return Subject.doAsPrivileged(s, action, acc);
        }
        return Subject.doAsPrivileged(s, action, acc);
    }

    public static void clearSubject() {
        threadLocal.remove();
    }
}

