/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.util.List;
import java.util.Locale;
import org.apache.jetspeed.i18n.LocalizedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetspeedLocale {
    private static final String DELIM = ",";

    public static Locale getDefaultLocale() {
        return Locale.ENGLISH;
    }

    public static String convertLocaleToString(Locale locale) {
        if (locale == null) {
            return null;
        }
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        StringBuffer buffer = new StringBuffer(40);
        if (language != null) {
            buffer.append(language);
        }
        buffer.append(DELIM);
        if (country != null) {
            buffer.append(country);
        }
        buffer.append(DELIM);
        if (variant != null) {
            buffer.append(variant);
        }
        return buffer.toString().trim();
    }

    public static Locale convertStringToLocale(String lang) {
        if (lang == null) {
            return null;
        }
        String country = "";
        String variant = "";
        String[] localeArray = lang.split("[-|_,]");
        for (int i = 0; i < localeArray.length; ++i) {
            if (i == 0) {
                lang = localeArray[i];
                continue;
            }
            if (i == 1) {
                country = localeArray[i];
                continue;
            }
            if (i != 2) continue;
            variant = localeArray[i];
        }
        return new Locale(lang, country, variant);
    }

    public static LocalizedObject getBestLocalizedObject(List<? extends LocalizedObject> list, Locale locale) {
        LocalizedObject fallback = null;
        for (LocalizedObject localizedObject : list) {
            if (localizedObject.getLocale().equals(locale)) {
                return localizedObject;
            }
            if (localizedObject.getLocale().getLanguage().equals(locale.getLanguage())) {
                fallback = localizedObject;
                continue;
            }
            if (fallback != null || !localizedObject.getLocale().equals(JetspeedLocale.getDefaultLocale())) continue;
            fallback = localizedObject;
        }
        return fallback;
    }
}

