/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletMode;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericPortletUtils {
    private GenericPortletUtils() {
    }

    public static Method getRenderModeHelperMethod(GenericPortlet genericPortlet, PortletMode mode) {
        return GenericPortletUtils.getRenderModeHelperMethod(genericPortlet.getClass(), mode);
    }

    public static Method getRenderModeHelperMethod(Class<? extends GenericPortlet> genericPortletClazz, PortletMode mode) {
        Method helperMethod = null;
        String modeName = mode.toString();
        for (Method method : genericPortletClazz.getMethods()) {
            Annotation[] annotations = method.getAnnotations();
            if (annotations == null) continue;
            for (Annotation annotation : annotations) {
                String name;
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (!RenderMode.class.equals(annotationType) || !modeName.equals(name = ((RenderMode)annotation).name())) continue;
                if (Modifier.isPublic(method.getModifiers())) {
                    return method;
                }
                return null;
            }
        }
        try {
            if (PortletMode.EDIT.equals((Object)mode)) {
                helperMethod = genericPortletClazz.getMethod("doEdit", RenderRequest.class, RenderResponse.class);
            } else if (PortletMode.HELP.equals((Object)mode)) {
                helperMethod = genericPortletClazz.getMethod("doHelp", RenderRequest.class, RenderResponse.class);
            } else if (PortletMode.VIEW.equals((Object)mode)) {
                helperMethod = genericPortletClazz.getMethod("doView", RenderRequest.class, RenderResponse.class);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (helperMethod != null && Modifier.isPublic(helperMethod.getModifiers())) {
            return helperMethod;
        }
        return null;
    }
}

