/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security;

import java.security.Permission;
import org.apache.jetspeed.security.PortalResourcePermission;

public class FolderPermission
extends PortalResourcePermission {
    public static final char RECURSIVE_CHAR = '-';
    public static final char WILD_CHAR = '*';
    public static final String WILD_CHAR_STR = new String(new char[]{'*'});
    public static final char FOLDER_SEPARATOR = '/';
    public static final String FOLDER_SEPARATOR_STR = new String(new char[]{'/'});
    private boolean folder;
    private boolean recursive;
    private String cpath;

    public FolderPermission(String name, String actions) {
        super(name, actions);
        this.parsePath();
    }

    public FolderPermission(String name, int mask) {
        super(name, mask);
        this.parsePath();
    }

    private void parsePath() {
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.folder = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        if (len == 0) {
            throw new IllegalArgumentException("invalid folder reference");
        }
        char last = this.cpath.charAt(len - 1);
        if (last == '-' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == '*' && (len == 1 || this.cpath.charAt(len - 2) == '/')) {
            this.folder = true;
            this.cpath = this.cpath.substring(0, --len);
        }
    }

    public boolean implies(Permission p) {
        if (!(p instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(FolderPermission that) {
        if (this.folder) {
            if (this.recursive) {
                if (that.folder) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.folder) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf(47);
            if (last == -1) {
                return false;
            }
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        return this.cpath.equals(that.cpath);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FolderPermission)) {
            return false;
        }
        FolderPermission that = (FolderPermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.folder == that.folder && this.recursive == that.recursive;
    }

    public int hashCode() {
        return this.cpath.hashCode();
    }
}

