/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.util;

import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class ConfigurationProperties
extends PropertiesConfiguration
implements InitializingBean {
    private Resource[] locations;
    private Properties[] localProperties;

    public void setProperties(Properties properties) {
        this.localProperties = new Properties[]{properties};
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (this.localProperties != null) {
            for (Properties props : this.localProperties) {
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    this.setProperty((String)entry.getKey(), entry.getValue());
                }
            }
        }
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource location = this.locations[i];
                try (InputStream is = null;){
                    is = location.getInputStream();
                    ConfigurationProperties config = this;
                    if (i > 0) {
                        config = new PropertiesConfiguration();
                    }
                    config.load(is);
                    if (i <= 0) continue;
                    ConfigurationUtils.copy((Configuration)config, (Configuration)this);
                    config.clear();
                    continue;
                }
            }
        }
    }
}

