/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.ContentCacheKey;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.impl.EhCacheElementImpl;
import org.apache.jetspeed.request.RequestContext;

public class EhCacheImpl
implements JetspeedCache {
    protected Ehcache ehcache;
    protected Map<JetspeedCacheEventListener, CacheEventListener> cacheEventListenersMap;

    public EhCacheImpl(Ehcache ehcache) {
        this.ehcache = ehcache;
        this.cacheEventListenersMap = new HashMap<JetspeedCacheEventListener, CacheEventListener>();
    }

    public CacheElement get(Object key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        return new EhCacheElementImpl(element);
    }

    public int getTimeToIdleSeconds() {
        return (int)this.ehcache.getTimeToIdleSeconds();
    }

    public int getTimeToLiveSeconds() {
        return (int)this.ehcache.getTimeToLiveSeconds();
    }

    public boolean isKeyInCache(Object key) {
        return this.ehcache.isKeyInCache(key);
    }

    public void put(CacheElement element) {
        EhCacheElementImpl impl = (EhCacheElementImpl)element;
        this.ehcache.put(impl.getImplElement());
    }

    public CacheElement createElement(Object key, Object content) {
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("The cache key must be serializable.");
        }
        if (content instanceof Serializable) {
            return new EhCacheElementImpl((Serializable)key, (Serializable)content);
        }
        return new EhCacheElementImpl((Serializable)key, content);
    }

    public boolean remove(Object key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return false;
        }
        boolean isRemoved = this.ehcache.remove(key);
        return isRemoved;
    }

    public boolean removeQuiet(Object key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return false;
        }
        return this.ehcache.removeQuiet(key);
    }

    public void clear() {
        this.ehcache.removeAll();
    }

    public void evictContentForUser(String username) {
    }

    public void evictContentForSession(String session) {
    }

    public void addEventListener(final JetspeedCacheEventListener listener, final boolean local) {
        CacheEventListener cacheEventListener = new CacheEventListener(){

            public void notifyElementEvicted(Ehcache cache, Element element) {
                listener.notifyElementEvicted((JetspeedCache)EhCacheImpl.this, local, (Object)element.getKey(), element.getObjectValue());
            }

            public void notifyElementExpired(Ehcache cache, Element element) {
                listener.notifyElementExpired((JetspeedCache)EhCacheImpl.this, local, (Object)element.getKey(), element.getObjectValue());
            }

            public void notifyElementPut(Ehcache cache, Element element) {
                listener.notifyElementAdded((JetspeedCache)EhCacheImpl.this, local, (Object)element.getKey(), element.getObjectValue());
            }

            public void notifyElementUpdated(Ehcache cache, Element element) {
                listener.notifyElementChanged((JetspeedCache)EhCacheImpl.this, local, (Object)element.getKey(), element.getObjectValue());
            }

            public void notifyElementRemoved(Ehcache cache, Element element) {
                listener.notifyElementRemoved((JetspeedCache)EhCacheImpl.this, local, (Object)element.getKey(), element == null ? null : element.getObjectValue());
            }

            public void notifyRemoveAll(Ehcache cache) {
                listener.notifyElementRemoved((JetspeedCache)EhCacheImpl.this, local, null, null);
            }

            public void dispose() {
            }

            public Object clone() {
                return this;
            }
        };
        this.cacheEventListenersMap.put(listener, cacheEventListener);
        this.ehcache.getCacheEventNotificationService().registerListener(cacheEventListener);
    }

    public void removeEventListener(JetspeedCacheEventListener listener, boolean local) {
        CacheEventListener cacheEventListener = this.cacheEventListenersMap.remove(listener);
        if (cacheEventListener != null) {
            this.ehcache.getCacheEventNotificationService().unregisterListener(cacheEventListener);
        }
    }

    public int getSize() {
        return this.ehcache.getSize();
    }

    public List getKeys() {
        return this.ehcache.getKeys();
    }

    public boolean isDistributed() {
        try {
            CacheManagerPeerProvider peerProvider = this.ehcache.getCacheManager().getCachePeerProvider();
            return peerProvider != null && peerProvider.listRemoteCachePeers(this.ehcache).size() > 0;
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void dispose() {
    }

    public ContentCacheKey createCacheKey(RequestContext rc, String windowId) {
        return null;
    }
}

