/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.cache.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import org.apache.jetspeed.cache.CacheElement;
import org.apache.jetspeed.cache.DistributedCacheObject;
import org.apache.jetspeed.cache.JetspeedCache;
import org.apache.jetspeed.cache.JetspeedCacheEventListener;
import org.apache.jetspeed.cache.impl.EhCacheDistributedElementImpl;
import org.apache.jetspeed.cache.impl.EhCacheImpl;
import org.apache.jetspeed.request.RequestContext;

public class EhCacheDistributedImpl
extends EhCacheImpl
implements JetspeedCache,
CacheEventListener {
    protected List localListeners = new ArrayList();
    protected List remoteListeners = new ArrayList();
    private Map refList = Collections.synchronizedMap(new HashMap());
    private boolean removeAllLocal = false;

    public EhCacheDistributedImpl(Ehcache ehcache) {
        super(ehcache);
        RegisteredEventListeners listeners = ehcache.getCacheEventNotificationService();
        listeners.registerListener((CacheEventListener)this);
    }

    public CacheElement get(Object key) {
        return this.get((Serializable)key);
    }

    public CacheElement get(Serializable key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        return new EhCacheDistributedElementImpl(element);
    }

    public boolean isKeyInCache(Object key) {
        if (key == null || !(key instanceof Serializable)) {
            return false;
        }
        return this.ehcache.isKeyInCache(key);
    }

    public boolean isKeyInCache(Serializable key) {
        return this.ehcache.isKeyInCache((Object)key);
    }

    public void put(CacheElement element) {
        EhCacheDistributedElementImpl impl = (EhCacheDistributedElementImpl)element;
        this.ehcache.put(impl.getImplElement());
        this.refList.put(impl.getKey(), impl);
        this.notifyListeners(true, 1, impl.getKey(), impl.getContent());
    }

    public CacheElement createElement(Object key, Object content) {
        if (!(key instanceof Serializable)) {
            throw new IllegalArgumentException("The cache key must be serializable.");
        }
        if (!(content instanceof DistributedCacheObject)) {
            throw new IllegalArgumentException("The cache content must be a distributed cache object.");
        }
        return new EhCacheDistributedElementImpl((Serializable)key, (DistributedCacheObject)content);
    }

    public CacheElement createElement(Serializable key, DistributedCacheObject content) {
        return new EhCacheDistributedElementImpl(key, content);
    }

    public boolean remove(Object key) {
        return this.remove((Serializable)key);
    }

    public boolean remove(Serializable key) {
        Element element = this.ehcache.get(key);
        this.refList.remove(key);
        if (element == null) {
            return false;
        }
        boolean isRemoved = this.ehcache.remove(key);
        if (isRemoved) {
            this.notifyListeners(true, -1, key, null);
        }
        return isRemoved;
    }

    public boolean removeQuiet(Object key) {
        Element element = this.ehcache.get(key);
        this.refList.remove(key);
        if (element == null) {
            return false;
        }
        return this.ehcache.removeQuiet(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.refList;
        synchronized (map) {
            this.removeAllLocal = true;
            super.clear();
            this.removeAllLocal = false;
        }
        this.notifyListeners(true, -1, null, null);
    }

    public void addEventListener(JetspeedCacheEventListener listener, boolean local) {
        if (local) {
            this.localListeners.add(listener);
        } else {
            this.remoteListeners.add(listener);
        }
    }

    public void removeEventListener(JetspeedCacheEventListener listener, boolean local) {
        if (local) {
            this.localListeners.remove(listener);
        } else {
            this.remoteListeners.remove(listener);
        }
    }

    public void evictContentForUser(RequestContext context) {
    }

    public String createCacheKey(String primary, String secondary) {
        return primary;
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public void dispose() {
        if (this.refList == null) {
            return;
        }
        Map temp = this.refList;
        this.refList = null;
        temp.clear();
        if (this.ehcache != null) {
            this.ehcache = null;
        }
    }

    protected void notifyListeners(boolean local, int action, Object key, Object value) {
        List listeners = local ? this.localListeners : this.remoteListeners;
        for (int ix = 0; ix < listeners.size(); ++ix) {
            try {
                JetspeedCacheEventListener listener = (JetspeedCacheEventListener)listeners.get(ix);
                switch (action) {
                    case 1: {
                        listener.notifyElementAdded((JetspeedCache)this, local, key, value);
                        break;
                    }
                    case 2: {
                        listener.notifyElementChanged((JetspeedCache)this, local, key, value);
                        break;
                    }
                    case -1: {
                        listener.notifyElementRemoved((JetspeedCache)this, local, key, value);
                        break;
                    }
                    case -2: {
                        listener.notifyElementEvicted((JetspeedCache)this, local, key, value);
                        break;
                    }
                    case -3: {
                        listener.notifyElementExpired((JetspeedCache)this, local, key, value);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void notifyElement(Ehcache cache, boolean local, Element arg1, int action) {
        if (cache != this.ehcache) {
            System.out.println("Cache=" + cache.getName() + " is not my cache=" + this.ehcache.getName());
            return;
        }
        try {
            EhCacheDistributedElementImpl e = (EhCacheDistributedElementImpl)this.refList.get(arg1.getKey());
            if (e != null) {
                if (action < 0) {
                    this.refList.remove(arg1.getKey());
                } else if (action == 1) {
                    this.refList.put(arg1.getKey(), arg1);
                }
                e.notifyChange(action);
                this.notifyListeners(local, action, arg1.getKey(), arg1.getObjectValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notifyElementEvicted(Ehcache cache, Element arg1) {
        this.notifyElement(cache, false, arg1, -2);
    }

    public void notifyElementExpired(Ehcache cache, Element arg1) {
        this.notifyElement(cache, false, arg1, -3);
    }

    public void notifyElementPut(Ehcache cache, Element arg1) throws CacheException {
        this.notifyElement(cache, false, arg1, 1);
    }

    public void notifyElementRemoved(Ehcache cache, Element arg1) throws CacheException {
        this.notifyElement(cache, false, arg1, -1);
    }

    public void notifyElementUpdated(Ehcache cache, Element arg1) throws CacheException {
        this.notifyElement(cache, false, arg1, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoveAll(Ehcache cache) {
        if (cache != this.ehcache) {
            System.out.println("Cache=" + cache.getName() + " is not my cache=" + this.ehcache.getName());
            return;
        }
        try {
            Map map = this.refList;
            synchronized (map) {
                for (EhCacheDistributedElementImpl e : this.refList.values()) {
                    this.notifyListeners(this.removeAllLocal, -1, e.getKey(), e.getContent());
                    e.notifyChange(-1);
                }
                this.refList.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

