/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.testhelpers;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.jetspeed.testhelpers.TestHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public abstract class AbstractTestHelper
implements TestHelper {
    public static final String APP_CONTEXT = "AppContext";
    private final Map context;
    private static final CompositeConfiguration USER_PROPERTIES;

    private static Configuration loadConfiguration(File propsFile) throws ConfigurationException {
        if (propsFile.exists()) {
            return new PropertiesConfiguration(propsFile);
        }
        return new PropertiesConfiguration();
    }

    public AbstractTestHelper(Map context) {
        this.context = context;
    }

    public AbstractTestHelper() {
        this.context = new HashMap();
    }

    public Map getContext() {
        return this.context;
    }

    public final String getUserProperty(String key) {
        String prop = System.getProperty(key);
        if (prop == null) {
            return USER_PROPERTIES.getString(key);
        }
        return prop;
    }

    protected final void addBeanFactory(ConfigurableBeanFactory bf) {
        ConfigurableBeanFactory currentBf = (ConfigurableBeanFactory)this.context.get(APP_CONTEXT);
        if (currentBf != null) {
            bf.setParentBeanFactory((BeanFactory)currentBf);
            this.context.put(APP_CONTEXT, new DefaultListableBeanFactory((BeanFactory)bf));
        } else {
            this.context.put(APP_CONTEXT, bf);
        }
    }

    static {
        try {
            File userBuildFile = new File(System.getProperty("user.home"), "build.properties");
            Configuration userBuildProps = AbstractTestHelper.loadConfiguration(userBuildFile);
            File mavenBuildFile = new File("../../build.properties");
            Configuration mavenBuildProps = AbstractTestHelper.loadConfiguration(mavenBuildFile);
            File mavenProjectFile = new File("../../project.properties");
            Configuration mavenProjectProps = AbstractTestHelper.loadConfiguration(mavenProjectFile);
            USER_PROPERTIES = new CompositeConfiguration();
            USER_PROPERTIES.addConfiguration(userBuildProps);
            USER_PROPERTIES.addConfiguration(mavenBuildProps);
            USER_PROPERTIES.addConfiguration(mavenProjectProps);
        }
        catch (ConfigurationException e) {
            throw new IllegalStateException("Unable to load ${USER_HOME}/build.properties");
        }
    }
}

