/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.mocks;

import com.mockrunner.mock.web.MockServletConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.mocks.BaseMockServletContext;
import org.apache.jetspeed.mocks.ResourceLocatingRequestDispatcher;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public class ResourceLocatingServletContext
extends BaseMockServletContext {
    protected static final Log log = LogFactory.getLog((Class)ResourceLocatingServletContext.class);
    private final File rootPath;
    private final Map pathOverrides = new HashMap();
    private final List servletInfoList = new ArrayList();
    private final List servletMappingInfoList = new ArrayList();
    private final Map servletInstanceMap = new HashMap();

    public ResourceLocatingServletContext(File rootPath) {
        this.rootPath = rootPath;
    }

    public ResourceLocatingServletContext(File rootPath, boolean loadServlet) {
        this.rootPath = rootPath;
        if (loadServlet) {
            this.loadServlets();
        }
    }

    public final void addPathOverride(String path, File file) {
        this.pathOverrides.put(path, file);
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.pathOverrides.containsKey(path)) {
            return ((File)this.pathOverrides.get(path)).toURL();
        }
        return new File(this.rootPath, path).toURL();
    }

    public String getRealPath(String path) {
        if (this.pathOverrides.containsKey(path)) {
            return ((File)this.pathOverrides.get(path)).getAbsolutePath();
        }
        return new File(this.rootPath, path).getAbsolutePath();
    }

    public InputStream getResourceAsStream(String path) {
        try {
            return this.getResource(path).openStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set getResourcePaths(String path) {
        File start = new File(this.rootPath, path);
        File[] children = start.listFiles();
        HashSet<String> pathes = new HashSet<String>();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            String relativePath = child.getPath().substring(this.rootPath.getPath().length()).replace('\\', '/');
            if (child.isDirectory()) {
                pathes.add(relativePath + "/");
                continue;
            }
            pathes.add(relativePath);
        }
        Iterator itr = this.pathOverrides.keySet().iterator();
        while (itr.hasNext()) {
            pathes.add((String)itr.next());
        }
        return pathes;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        Servlet servlet = this.findServletByPath(arg0);
        if (servlet == null) {
            throw new IllegalArgumentException("Failed to find servlet for the path: " + arg0);
        }
        return new ResourceLocatingRequestDispatcher(servlet, arg0, null);
    }

    protected Servlet findServletByPath(String path) {
        Servlet servlet = null;
        Iterator it = this.servletMappingInfoList.iterator();
        while (it.hasNext()) {
            Perl5Matcher matcher;
            ServletMappingInfo servletMappingInfo = (ServletMappingInfo)it.next();
            Pattern pattern = servletMappingInfo.getPattern();
            if (pattern == null || !(matcher = new Perl5Matcher()).matches(path, pattern) && !matcher.matches(path + "/", pattern)) continue;
            servlet = (Servlet)this.servletInstanceMap.get(servletMappingInfo.getServletName());
            break;
        }
        return servlet;
    }

    protected void loadServlets() {
        this.servletInfoList.clear();
        this.servletMappingInfoList.clear();
        Digester digester = new Digester();
        digester.addObjectCreate("web-app/servlet", ServletInfo.class);
        digester.addBeanPropertySetter("web-app/servlet/servlet-name", "servletName");
        digester.addBeanPropertySetter("web-app/servlet/servlet-class", "servletClass");
        digester.addCallMethod("web-app/servlet/init-param", "addInitParam", 2);
        digester.addCallParam("web-app/servlet/init-param/param-name", 0);
        digester.addCallParam("web-app/servlet/init-param/param-value", 1);
        digester.addRule("web-app/servlet", (Rule)new ServletRule(this.servletInfoList));
        digester.addObjectCreate("web-app/servlet-mapping", ServletMappingInfo.class);
        digester.addBeanPropertySetter("web-app/servlet-mapping/servlet-name", "servletName");
        digester.addBeanPropertySetter("web-app/servlet-mapping/url-pattern", "urlPattern");
        digester.addRule("web-app/servlet-mapping", (Rule)new ServletMappingRule(this.servletMappingInfoList));
        File webInfPath = new File(this.rootPath, "WEB-INF");
        File webDescriptorFile = new File(webInfPath, "web.xml");
        log.debug((Object)("parsing webDescriptorFile: " + webDescriptorFile));
        try {
            digester.parse(webDescriptorFile);
        }
        catch (Exception e) {
            log.error((Object)("Failed to parse webDescriptorFile: " + webDescriptorFile), (Throwable)e);
        }
        Iterator it = this.servletInfoList.iterator();
        while (it.hasNext()) {
            ServletInfo servletInfo = (ServletInfo)it.next();
            try {
                Servlet servlet = (Servlet)Class.forName(servletInfo.getServletClass()).newInstance();
                MockServletConfig servletConfig = new MockServletConfig();
                servletConfig.setServletContext((ServletContext)this);
                Map initParamMap = servletInfo.getInitParamMap();
                Iterator itParam = initParamMap.keySet().iterator();
                while (itParam.hasNext()) {
                    String paramName = (String)itParam.next();
                    String paramValue = (String)initParamMap.get(paramName);
                    servletConfig.setInitParameter(paramName, paramValue);
                }
                servlet.init((ServletConfig)servletConfig);
                this.servletInstanceMap.put(servletInfo.getServletName(), servlet);
            }
            catch (Exception e) {
                log.error((Object)("Failed to load and initialize servlet: " + servletInfo));
            }
        }
    }

    public static class ServletMappingRule
    extends Rule {
        private List servletMappingInfoList;

        public ServletMappingRule(List servletMappingInfoList) {
            this.servletMappingInfoList = servletMappingInfoList;
        }

        public void end(String namespace, String name) {
            try {
                ServletMappingInfo servletMappingInfo = (ServletMappingInfo)this.digester.peek(0);
                this.servletMappingInfoList.add(servletMappingInfo);
            }
            catch (Exception e) {
                log.error((Object)"Exception occurred in ServletMappingRule", (Throwable)e);
            }
        }
    }

    public static class ServletRule
    extends Rule {
        private List servletInfoList;

        public ServletRule(List servletInfoList) {
            this.servletInfoList = servletInfoList;
        }

        public void end(String namespace, String name) {
            try {
                ServletInfo servletInfo = (ServletInfo)this.digester.peek(0);
                this.servletInfoList.add(servletInfo);
            }
            catch (Exception e) {
                log.error((Object)"Exception occurred in ServletRule", (Throwable)e);
            }
        }
    }

    public static class ServletMappingInfo {
        protected String servletName;
        protected String urlPattern;
        protected Pattern pattern;

        public void setServletName(String servletName) {
            this.servletName = servletName;
        }

        public String getServletName() {
            return this.servletName;
        }

        public void setUrlPattern(String urlPattern) {
            this.urlPattern = urlPattern;
            this.pattern = null;
            try {
                GlobCompiler compiler = new GlobCompiler();
                this.pattern = compiler.compile(this.urlPattern);
            }
            catch (Exception e) {
                log.error((Object)("Invalid url pattern: " + this.urlPattern));
            }
        }

        public String getUrlPattern() {
            return this.urlPattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            return "ServletMappingInfo [" + this.urlPattern + ", " + this.servletName + "]";
        }
    }

    public static class ServletInfo {
        protected String servletName;
        protected String servletClass;
        protected Map initParamMap = new HashMap();

        public void setServletName(String servletName) {
            this.servletName = servletName;
        }

        public String getServletName() {
            return this.servletName;
        }

        public void setServletClass(String servletClass) {
            this.servletClass = servletClass;
        }

        public String getServletClass() {
            return this.servletClass;
        }

        public void addInitParam(String paramName, String paramValue) {
            this.initParamMap.put(paramName, paramValue);
        }

        public Map getInitParamMap() {
            return this.initParamMap;
        }

        public String toString() {
            return "ServletInfo [" + this.servletName + ", " + this.servletClass + ", " + this.initParamMap + "]";
        }
    }
}

