/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.components.test;

import java.util.Properties;
import junit.framework.TestCase;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractSpringTestCase
extends TestCase {
    protected ClassPathXmlApplicationContext ctx;

    protected void setUp() throws Exception {
        super.setUp();
        if (this.ctx == null) {
            String[] bootConfigurations = this.getBootConfigurations();
            if (bootConfigurations != null) {
                ClassPathXmlApplicationContext bootContext = new ClassPathXmlApplicationContext(bootConfigurations, true);
                this.ctx = new ClassPathXmlApplicationContext(this.getConfigurations(), false, (ApplicationContext)bootContext);
            } else {
                this.ctx = new ClassPathXmlApplicationContext(this.getConfigurations(), false);
            }
            PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
            Properties p = this.getPostProcessProperties();
            p.setProperty("applicationRoot", "../../src/webapp");
            ppc.setProperties(p);
            this.ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
            this.ctx.refresh();
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    protected abstract String[] getConfigurations();

    protected String[] getBootConfigurations() {
        return null;
    }

    protected Properties getPostProcessProperties() {
        return new Properties();
    }
}

