/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.anttasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Reference;

public class ArchetypeDescriptor
extends Task {
    private String header;
    private String artifactId;
    private Boolean allowPartial = new Boolean(true);
    private File baseDir;
    private File destFile;
    private Reference sourcesRefId;
    private Reference resourcesRefId;
    private Reference testSourcesRefId;
    private Reference testResourcesRefId;
    private Reference siteResourcesRefId;

    public void addText(String header) {
        this.header = this.getProject().replaceProperties(header);
    }

    public void setArtifactid(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setAllowpartial(Boolean allowPartial) {
        this.allowPartial = allowPartial;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setDestfile(File destFile) {
        this.destFile = destFile;
    }

    public void setSourcesrefid(Reference sourcesRefId) {
        this.sourcesRefId = sourcesRefId;
    }

    public void setResourcesrefid(Reference resourcesRefId) {
        this.resourcesRefId = resourcesRefId;
    }

    public void setTestsourcesrefid(Reference testSourcesRefId) {
        this.testSourcesRefId = testSourcesRefId;
    }

    public void setTestresourcesrefid(Reference testResourcesRefId) {
        this.testResourcesRefId = testResourcesRefId;
    }

    public void setSiteresourcesrefid(Reference siteResourcesRefId) {
        this.siteResourcesRefId = siteResourcesRefId;
    }

    public void execute() throws BuildException {
        if (this.artifactId == null || this.baseDir == null || this.destFile == null) {
            throw new BuildException("required artifactid, basedir, or destfile attribute missing", this.getLocation());
        }
        List sources = this.archetypeFiles(this.sourcesRefId, "sourcesrefid");
        List resources = this.archetypeFiles(this.resourcesRefId, "resourcesrefid");
        List testSources = this.archetypeFiles(this.testSourcesRefId, "testsourcesrefid");
        List testResources = this.archetypeFiles(this.testResourcesRefId, "testresourcesrefid");
        List siteResources = this.archetypeFiles(this.siteResourcesRefId, "siteresourcesrefid");
        PrintWriter writer = null;
        try {
            File destDir = this.destFile.getParentFile();
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.destFile), "UTF-8"));
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            if (this.header != null) {
                writer.println(this.header);
            }
            writer.println("<archetype>");
            writer.println("    <id>" + this.artifactId + "</id>");
            writer.println("    <allowPartial>" + this.allowPartial + "</allowPartial>");
            this.writeFiles(writer, "sources", "source", sources);
            this.writeFiles(writer, "resources", "resource", resources);
            this.writeFiles(writer, "testSources", "source", testSources);
            this.writeFiles(writer, "testResources", "resource", testResources);
            this.writeFiles(writer, "siteResources", "resource", siteResources);
            writer.println("</archetype>");
        }
        catch (IOException ioe) {
            throw new BuildException("unable to write decriptor", (Throwable)ioe, this.getLocation());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        int archetypeSourcesCount = sources.size() + resources.size() + testSources.size() + testResources.size() + siteResources.size();
        this.log("generated " + this.destFile + " including " + archetypeSourcesCount + " source/resource files");
    }

    private List archetypeFiles(Reference refId, String name) throws BuildException {
        ArrayList<String> archetypeFiles = new ArrayList<String>();
        if (refId != null) {
            if (!(refId.getReferencedObject(this.getProject()) instanceof AbstractFileSet)) {
                throw new BuildException(name + " attribute must reference a fileset", this.getLocation());
            }
            AbstractFileSet fileSet = (AbstractFileSet)refId.getReferencedObject(this.getProject());
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] files = directoryScanner.getIncludedFiles();
            if (files != null && files.length > 0) {
                String basePath = this.canonicalPath(this.baseDir);
                for (int i = 0; i < files.length; ++i) {
                    File file;
                    String filePath;
                    String archetypePath = files[i];
                    if (basePath != null && (filePath = this.canonicalPath(file = new File(fileSet.getDir(this.getProject()), files[i]))) != null && filePath.startsWith(basePath) && (archetypePath = filePath.substring(basePath.length())).startsWith("/")) {
                        archetypePath = archetypePath.substring(1);
                    }
                    archetypeFiles.add(archetypePath);
                }
            }
        }
        return archetypeFiles;
    }

    private String canonicalPath(File file) {
        try {
            String path = file.getCanonicalPath();
            return path.replace('\\', '/');
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private void writeFiles(PrintWriter writer, String collectionElementName, String elementName, List files) throws IOException {
        if (!files.isEmpty()) {
            writer.println("    <" + collectionElementName + ">");
            Iterator fileIter = files.iterator();
            while (fileIter.hasNext()) {
                writer.println("        <" + elementName + ">" + (String)fileIter.next() + "</" + elementName + ">");
            }
            writer.println("    </" + collectionElementName + ">");
        }
    }
}

