/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.jetspeed.contentserver.ContentLocator;

public class ContentLocatingRequestWrapper
extends HttpServletRequestWrapper {
    private ContentLocator contentLocator;
    private HttpServletRequest request;
    private boolean readerCalled;
    private boolean isCalled = false;

    public ContentLocatingRequestWrapper(HttpServletRequest request, ContentLocator contentLocator) {
        super(request);
        this.contentLocator = contentLocator;
        this.request = request;
        String basePath = contentLocator.getBasePath();
        this.request.setAttribute("javax.servlet.include.servlet_path", (Object)basePath);
        this.request.setAttribute("javax.servlet.include.request_uri", (Object)basePath);
    }

    public String getRequestURI() {
        String basePath = this.contentLocator.getBasePath();
        return basePath;
    }

    public StringBuffer getRequestURL() {
        StringBuffer buf = new StringBuffer(super.getRequestURL().length());
        buf.append(this.request.getScheme()).append("://").append(this.request.getServerName()).append(":").append(this.request.getServerPort()).append(this.request.getContextPath()).append(this.contentLocator.getBasePath());
        return buf;
    }

    public String getServletPath() {
        return this.contentLocator.getBasePath();
    }

    public String getContextPath() {
        String cPath = super.getContextPath();
        return cPath;
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        return pathInfo;
    }

    public String getPathTranslated() {
        String pathTranslated = super.getPathTranslated();
        return pathTranslated;
    }
}

