/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.contentserver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jetspeed.contentserver.ContentLocator;
import org.apache.jetspeed.contentserver.SimpleContentLocator;

public abstract class AbstractContentLocator
implements ContentLocator {
    protected String rootPath;
    protected boolean useCachedLookup;
    protected static final Map fileCache = new HashMap();
    protected String[] URLHints;
    protected static final Log log = LogFactory.getLog((Class)SimpleContentLocator.class);
    protected String contextRoot;
    protected String URI;
    protected List lookupPathes;
    private String basePath;
    protected File contentFile;

    public AbstractContentLocator(String rootPath, String[] URLHints, boolean useCachedLookup, String contextRoot, String URI2, List lookupPathes) throws FileNotFoundException {
        this.contextRoot = contextRoot;
        this.rootPath = rootPath;
        this.useCachedLookup = useCachedLookup;
        this.URLHints = URLHints;
        this.URI = URI2;
        this.lookupPathes = lookupPathes;
        String realPath = this.getRealPath();
        if (realPath == null) {
            throw new FileNotFoundException("Target path " + URI2 + " not found withint the content locations provided");
        }
        this.contentFile = new File(realPath);
    }

    public OutputStream getOutputStream() throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new ByteArrayOutputStream((int)this.contentFile.length()));
        this.writeToOutputStream(bos);
        return bos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeToOutputStream(OutputStream stream) throws IOException {
        InputStream is = this.getInputStream();
        if (is != null) {
            long l;
            try {
                long size = 0L;
                int j = is.read();
                while (j != -1) {
                    stream.write((byte)j);
                    ++size;
                    j = is.read();
                }
                l = size;
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
            return l;
        }
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        String realPath = this.getRealPath();
        if (realPath == null) {
            throw new FileNotFoundException("The " + this.URI + " could not be resolved by the ContentLocator");
        }
        if (this.contentFile != null) {
            return new BufferedInputStream(new FileInputStream(this.contentFile));
        }
        throw new FileNotFoundException("Failed to load content source " + realPath);
    }

    public String getBasePath() {
        if (this.basePath == null) {
            String absPath = this.getRealPath();
            if (absPath != null) {
                absPath = absPath.replace('\\', '/');
                int startOffset = absPath.indexOf(this.contextRoot) + this.contextRoot.length();
                this.basePath = absPath.substring(startOffset, absPath.length());
            } else {
                this.basePath = this.URI;
            }
        }
        return this.basePath;
    }

    public Date getLastModified() {
        return new Date(this.contentFile.lastModified());
    }
}

