/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.discovery;

import com.google.step2.discovery.HostMeta;
import com.google.step2.discovery.Link;
import com.google.step2.discovery.LinkBase;
import com.google.step2.discovery.LinkPattern;
import com.google.step2.discovery.RelType;
import com.google.step2.discovery.RelTypes;
import com.google.step2.discovery.UriTemplate;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openid4java.discovery.UrlIdentifier;

public class XrdLocationSelector {
    public static final RelType REL_OPENID_OP_XRD = new RelType("http://reltype.google.com/openid/xrd-op");
    public static final RelType REL_OPENID_RP_XRD = new RelType("http://reltype.google.com/openid/xrd-rp");
    public static final RelType REL_OPENID_XRD = new RelType("http://reltype.google.com/openid/xrd");
    public static final RelType REL_DESCRIBED_BY = new RelType("describedby");
    private static final Ordering OP_PREFERENCE_ORDER = new Ordering(RelTypes.setOf(REL_DESCRIBED_BY, REL_OPENID_OP_XRD), RelTypes.setOf(REL_DESCRIBED_BY, REL_OPENID_XRD), RelTypes.setOf(REL_DESCRIBED_BY));
    private static final Ordering RP_PREFERENCE_ORDER = new Ordering(RelTypes.setOf(REL_DESCRIBED_BY, REL_OPENID_RP_XRD), RelTypes.setOf(REL_DESCRIBED_BY, REL_OPENID_XRD), RelTypes.setOf(REL_DESCRIBED_BY));

    public URI findUserXrdUriForOp(HostMeta hostMeta, String mimeType, UrlIdentifier claimedId) {
        LinkPattern pattern = this.getMatchingLink(hostMeta.getLinkPatterns(), mimeType);
        if (pattern == null) {
            return null;
        }
        UriTemplate template = new UriTemplate(pattern.getUriPattern());
        return template.map(URI.create(claimedId.getIdentifier()));
    }

    public URI findSiteXrdUriForOp(HostMeta hostMeta, String mimeType) {
        Link link = this.getMatchingLink(hostMeta.getLinks(), mimeType);
        return link == null ? null : link.getUri();
    }

    private <T extends LinkBase> T getMatchingLink(Collection<T> links, String mimeType) {
        List<T> sortableLinks = this.filterByMimeType(links, mimeType);
        if (sortableLinks.size() < 1) {
            return null;
        }
        Collections.sort(sortableLinks, OP_PREFERENCE_ORDER);
        LinkBase candidate = (LinkBase)sortableLinks.get(0);
        RelTypes candidateRelTypes = candidate.getRelationships();
        for (RelTypes validRelTypes : OP_PREFERENCE_ORDER.getAllRelTypeSets()) {
            if (!candidateRelTypes.containsAll(validRelTypes)) continue;
            return (T)candidate;
        }
        return null;
    }

    private <T extends LinkBase> List<T> filterByMimeType(Collection<T> links, String mimeType) {
        ArrayList<LinkBase> result = new ArrayList<LinkBase>();
        for (LinkBase link : links) {
            if (!mimeType.equals(link.getMimeType())) continue;
            result.add(link);
        }
        return result;
    }

    private static class Ordering
    implements Comparator<LinkBase> {
        private final List<RelTypes> rels;
        private final Integer maxValue;

        public Ordering(RelTypes ... rels) {
            this.rels = Arrays.asList(rels);
            this.maxValue = rels.length;
        }

        @Override
        public int compare(LinkBase o1, LinkBase o2) {
            return this.getOrdinal(o1).compareTo(this.getOrdinal(o2));
        }

        public List<RelTypes> getAllRelTypeSets() {
            return this.rels;
        }

        private Integer getOrdinal(LinkBase o2) {
            for (int i = 0; i < this.rels.size(); ++i) {
                if (!o2.getRelationships().containsAll(this.rels.get(i))) continue;
                return i;
            }
            return this.maxValue;
        }
    }
}

