/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration.operation;

import java.util.Map;
import javax.json.JsonObject;
import org.apache.polygene.migration.Migrator;
import org.apache.polygene.migration.assembly.EntityMigrationOperation;
import org.apache.polygene.migration.assembly.MigrationContext;
import org.apache.polygene.spi.entitystore.helpers.StateStore;

public class RemoveNamedAssociation
implements EntityMigrationOperation {
    private final String association;
    private final Map<String, String> defaultReferences;

    public RemoveNamedAssociation(String association, Map<String, String> defaultReferences) {
        this.association = association;
        this.defaultReferences = defaultReferences;
    }

    @Override
    public JsonObject upgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        return migrator.removeNamedAssociation(context, state, this.association);
    }

    @Override
    public JsonObject downgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        return migrator.addNamedAssociation(context, state, this.association, this.defaultReferences);
    }

    public String toString() {
        return "Remove named-association " + this.association + ", default:" + this.defaultReferences;
    }
}

