/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration.assembly;

import java.util.Arrays;
import javax.json.JsonObject;
import org.apache.polygene.migration.Migrator;
import org.apache.polygene.migration.assembly.AbstractMigrationRule;
import org.apache.polygene.migration.assembly.EntityMigrationOperation;
import org.apache.polygene.migration.assembly.MigrationContext;
import org.apache.polygene.spi.entitystore.helpers.StateStore;

public class EntityMigrationRule
extends AbstractMigrationRule {
    private final String[] entityTypes;
    private final EntityMigrationOperation entityOperation;

    public EntityMigrationRule(String fromVersion, String toVersion, String[] entityTypes, EntityMigrationOperation entityOperation) {
        super(fromVersion, toVersion);
        this.entityTypes = entityTypes;
        this.entityOperation = entityOperation;
    }

    public String[] entityTypes() {
        return this.entityTypes;
    }

    public JsonObject upgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        if (this.appliesTo(state.getString("type"))) {
            return this.entityOperation.upgrade(context, state, stateStore, migrator);
        }
        context.addFailure(this.entityOperation.toString());
        return state;
    }

    public JsonObject downgrade(MigrationContext context, JsonObject state, StateStore stateStore, Migrator migrator) {
        if (this.appliesTo(state.getString("type"))) {
            return this.entityOperation.downgrade(context, state, stateStore, migrator);
        }
        context.addFailure(this.entityOperation.toString());
        return state;
    }

    public boolean appliesTo(String entityType) {
        for (String type : this.entityTypes) {
            if (!entityType.equals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.fromVersion + "=>" + this.toVersion + ": on " + Arrays.asList(this.entityTypes) + " do " + this.entityOperation;
    }
}

