/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.migration.assembly;

import java.util.Map;
import org.apache.polygene.migration.assembly.EntityMigrationOperation;
import org.apache.polygene.migration.assembly.EntityMigrationRule;
import org.apache.polygene.migration.assembly.VersionMigrationBuilder;
import org.apache.polygene.migration.operation.AddAssociation;
import org.apache.polygene.migration.operation.AddManyAssociation;
import org.apache.polygene.migration.operation.AddNamedAssociation;
import org.apache.polygene.migration.operation.AddProperty;
import org.apache.polygene.migration.operation.RemoveAssociation;
import org.apache.polygene.migration.operation.RemoveManyAssociation;
import org.apache.polygene.migration.operation.RemoveNamedAssociation;
import org.apache.polygene.migration.operation.RemoveProperty;
import org.apache.polygene.migration.operation.RenameAssociation;
import org.apache.polygene.migration.operation.RenameManyAssociation;
import org.apache.polygene.migration.operation.RenameNamedAssociation;
import org.apache.polygene.migration.operation.RenameProperty;

public class EntityMigrationBuilder {
    private final VersionMigrationBuilder migrationBuilder;
    private final String[] entityTypes;

    public EntityMigrationBuilder(VersionMigrationBuilder migrationBuilder, String[] entityTypes) {
        this.migrationBuilder = migrationBuilder;
        this.entityTypes = entityTypes;
    }

    public VersionMigrationBuilder end() {
        return this.migrationBuilder;
    }

    public EntityMigrationBuilder renameProperty(String from, String to) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RenameProperty(from, to)));
        return this;
    }

    public EntityMigrationBuilder addProperty(String property, Object defaultValue) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new AddProperty(property, defaultValue)));
        return this;
    }

    public EntityMigrationBuilder removeProperty(String property, String defaultValue) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RemoveProperty(property, defaultValue)));
        return this;
    }

    public EntityMigrationBuilder renameAssociation(String from, String to) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RenameAssociation(from, to)));
        return this;
    }

    public EntityMigrationBuilder addAssociation(String association, String defaultReference) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new AddAssociation(association, defaultReference)));
        return this;
    }

    public EntityMigrationBuilder removeAssociation(String association, String defaultReference) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RemoveAssociation(association, defaultReference)));
        return this;
    }

    public EntityMigrationBuilder addManyAssociation(String association, String ... defaultReferences) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new AddManyAssociation(association, defaultReferences)));
        return this;
    }

    public EntityMigrationBuilder removeManyAssociation(String association, String ... defaultReferences) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RemoveManyAssociation(association, defaultReferences)));
        return this;
    }

    public EntityMigrationBuilder renameManyAssociation(String from, String to) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RenameManyAssociation(from, to)));
        return this;
    }

    public EntityMigrationBuilder addNamedAssociation(String association, Map<String, String> defaultReferences) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new AddNamedAssociation(association, defaultReferences)));
        return this;
    }

    public EntityMigrationBuilder removeNamedAssociation(String association, Map<String, String> defaultReferences) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RemoveNamedAssociation(association, defaultReferences)));
        return this;
    }

    public EntityMigrationBuilder renameNamedAssociation(String from, String to) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, new RenameNamedAssociation(from, to)));
        return this;
    }

    public EntityMigrationBuilder custom(EntityMigrationOperation operationEntity) {
        this.migrationBuilder.builder.entityMigrationRules().addRule(new EntityMigrationRule(this.migrationBuilder.fromVersion, this.migrationBuilder.toVersion, this.entityTypes, operationEntity));
        return this;
    }
}

