/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.index.solr.internal;

import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.polygene.api.common.Optional;
import org.apache.polygene.api.composite.Composite;
import org.apache.polygene.api.entity.EntityReference;
import org.apache.polygene.api.injection.scope.Service;
import org.apache.polygene.api.query.grammar.OrderBy;
import org.apache.polygene.api.query.grammar.QuerySpecification;
import org.apache.polygene.index.solr.EmbeddedSolrService;
import org.apache.polygene.index.solr.SolrSearch;
import org.apache.polygene.spi.query.EntityFinder;
import org.apache.polygene.spi.query.EntityFinderException;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrEntityQueryMixin
implements EntityFinder,
SolrSearch {
    @Service
    private EmbeddedSolrService solr;
    private Logger logger = LoggerFactory.getLogger(SolrEntityQueryMixin.class);

    public Stream<EntityReference> findEntities(Class<?> resultType, Predicate<Composite> whereClause, List<OrderBy> orderBySegments, Integer firstResult, Integer maxResults, Map<String, Object> variables) throws EntityFinderException {
        try {
            QuerySpecification expr = (QuerySpecification)whereClause;
            SolrServer server = this.solr.solrServer();
            NamedList list = new NamedList();
            list.add("q", (Object)expr.query());
            list.add("rows", (Object)(maxResults != 0 ? maxResults : 10000));
            list.add("start", (Object)firstResult);
            if (orderBySegments != null && orderBySegments.size() > 0) {
                for (OrderBy orderBySegment : orderBySegments) {
                    String propName = ((Member)((Object)orderBySegment.property().accessor())).getName() + "_for_sort";
                    String order = orderBySegment.order() == OrderBy.Order.ASCENDING ? "asc" : "desc";
                    list.add("sort", (Object)(propName + " " + order));
                }
            }
            SolrParams solrParams = SolrParams.toSolrParams((NamedList)list);
            this.logger.debug("Search:" + list.toString());
            QueryResponse query = server.query(solrParams);
            SolrDocumentList results = query.getResults();
            ArrayList<EntityReference> references = new ArrayList<EntityReference>(results.size());
            for (SolrDocument result : results) {
                references.add(EntityReference.parseEntityReference((String)result.getFirstValue("id").toString()));
            }
            return references.stream();
        }
        catch (SolrServerException e) {
            throw new EntityFinderException((Throwable)e);
        }
    }

    public EntityReference findEntity(Class<?> resultType, @Optional Predicate<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        return this.findEntities(resultType, whereClause, null, 0, 1, variables).findFirst().orElse(null);
    }

    public long countEntities(Class<?> resultType, @Optional Predicate<Composite> whereClause, Map<String, Object> variables) throws EntityFinderException {
        return this.findEntities(resultType, whereClause, null, 0, 1, variables).count();
    }

    @Override
    public SolrDocumentList search(String queryString) throws SolrServerException {
        SolrServer server = this.solr.solrServer();
        NamedList list = new NamedList();
        list.add("q", (Object)queryString);
        QueryResponse query = server.query(SolrParams.toSolrParams((NamedList)list));
        return query.getResults();
    }
}

