/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.index.solr.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.polygene.api.injection.scope.Service;
import org.apache.polygene.api.injection.scope.Uses;
import org.apache.polygene.index.solr.EmbeddedSolrService;
import org.apache.polygene.index.solr.SolrQueryService;
import org.apache.polygene.library.rdf.entity.EntityStateSerializer;
import org.apache.polygene.serialization.javaxjson.JavaxJsonFactories;
import org.apache.polygene.spi.entity.EntityState;
import org.apache.polygene.spi.entity.EntityStatus;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrEntityIndexerMixin
implements SolrQueryService {
    @Service
    private EmbeddedSolrService solr;
    @Service
    private JavaxJsonFactories jsonFactories;
    @Uses
    private EntityStateSerializer stateSerializer;
    private SolrServer server;
    private Map<String, SchemaField> indexedFields;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void inflateSolrSchema() {
        this.server = this.solr.solrServer();
        try (SolrCore solrCore = this.solr.solrCore();){
            this.indexedFields = solrCore.getSchema().getFields();
        }
    }

    @Override
    public void releaseSolrSchema() {
        this.server = null;
        this.indexedFields = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyChanges(Iterable<EntityState> entityStates) {
        try {
            try {
                ArrayList<String> deleted = null;
                ArrayList<SolrInputDocument> added = new ArrayList<SolrInputDocument>();
                for (EntityState entityState : entityStates) {
                    if (!entityState.entityDescriptor().queryable()) continue;
                    if (entityState.status().equals((Object)EntityStatus.REMOVED)) {
                        if (deleted == null) {
                            deleted = new ArrayList<String>();
                        }
                        deleted.add(entityState.entityReference().identity().toString());
                        continue;
                    }
                    if (entityState.status().equals((Object)EntityStatus.UPDATED)) {
                        added.add(this.indexEntityState(entityState));
                        continue;
                    }
                    if (!entityState.status().equals((Object)EntityStatus.NEW)) continue;
                    added.add(this.indexEntityState(entityState));
                }
                if (deleted != null) {
                    this.server.deleteById(deleted);
                }
                if (!added.isEmpty()) {
                    this.server.add(added);
                }
            }
            finally {
                if (this.server != null) {
                    this.server.commit(false, false);
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("Could not update Solr", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private SolrInputDocument indexEntityState(EntityState entityState) throws IOException, SolrServerException {
        graph = new GraphImpl();
        this.stateSerializer.serialize(entityState, false, (Graph)graph);
        input = new SolrInputDocument();
        input.addField("id", (Object)entityState.entityReference().identity());
        input.addField("type", (Object)((Class)entityState.entityDescriptor().types().findFirst().get()).getName());
        input.addField("lastModified", (Object)Date.from(entityState.lastModified()));
lbl7:
        // 19 sources

        block29: for (Statement statement : graph) {
            block39: {
                block40: {
                    field = this.indexedFields.get(statement.getPredicate().getLocalName());
                    if (field == null) continue;
                    if (!(statement.getObject() instanceof Literal)) break block39;
                    value = statement.getObject().stringValue();
                    if (!field.getType().getTypeName().equals("json")) break block40;
                    parser = this.jsonFactories.parserFactory().createParser((Reader)new StringReader(value));
                    var9_9 = null;
                    try {
                        event = parser.next();
                        switch (1.$SwitchMap$javax$json$stream$JsonParser$Event[event.ordinal()]) {
                            case 1: {
                                reader = this.jsonFactories.readerFactory().createReader((Reader)new StringReader(value));
                                var12_14 = null;
                                this.indexJson(input, reader.readArray());
                                if (reader == null) continue block29;
                                if (var12_14 == null) ** GOTO lbl31
                                try {
                                    reader.close();
                                }
                                catch (Throwable var13_16) {
                                    var12_14.addSuppressed(var13_16);
                                }
                                continue block29;
lbl31:
                                // 1 sources

                                reader.close();
                                ** break;
                                catch (Throwable var13_17) {
                                    try {
                                        var12_14 = var13_17;
                                        throw var13_17;
                                    }
                                    catch (Throwable var14_20) {
                                        if (reader != null) {
                                            if (var12_14 != null) {
                                                try {
                                                    reader.close();
                                                }
                                                catch (Throwable var15_21) {
                                                    var12_14.addSuppressed(var15_21);
                                                }
                                            } else {
                                                reader.close();
                                            }
                                        }
                                        throw var14_20;
                                    }
                                }
                            }
                            case 2: {
                                reader = this.jsonFactories.readerFactory().createReader((Reader)new StringReader(value));
                                var12_14 = null;
                                this.indexJson(input, reader.readObject());
                                if (reader == null) ** break;
                                if (var12_14 == null) ** GOTO lbl61
                                try {
                                    reader.close();
                                }
                                catch (Throwable var13_18) {
                                    var12_14.addSuppressed(var13_18);
                                }
                                continue block29;
lbl61:
                                // 1 sources

                                reader.close();
                                ** break;
                                catch (Throwable var13_19) {
                                    try {
                                        var12_14 = var13_19;
                                        throw var13_19;
                                    }
                                    catch (Throwable var16_22) {
                                        if (reader != null) {
                                            if (var12_14 != null) {
                                                try {
                                                    reader.close();
                                                }
                                                catch (Throwable var17_23) {
                                                    var12_14.addSuppressed(var17_23);
                                                }
                                            } else {
                                                reader.close();
                                            }
                                        }
                                        throw var16_22;
                                    }
                                }
                            }
                            ** default:
lbl79:
                            // 1 sources

                            continue block29;
                        }
                    }
                    catch (Throwable event) {
                        var9_9 = event;
                        throw event;
                    }
                    finally {
                        if (parser == null) continue;
                        if (var9_9 != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable event) {
                                var9_9.addSuppressed(event);
                            }
                            continue;
                        }
                        parser.close();
                        continue;
                    }
                }
                input.addField(field.getName(), (Object)value);
                continue;
            }
            if (statement.getObject() instanceof URI && !"type".equals(field.getName())) {
                value = statement.getObject().stringValue();
                value = value.substring(value.lastIndexOf(58) + 1, value.length());
                name = field.getName();
                input.addField(name, (Object)value);
                continue;
            }
            if (!(statement.getObject() instanceof BNode)) continue;
            resource = (Resource)statement.getObject();
            uri = new URIImpl("http://www.w3.org/1999/02/22-rdf-syntax-ns#li");
            seq = graph.match(resource, (URI)uri, null, new Resource[]{null});
            while (seq.hasNext()) {
                seqStatement = (Statement)seq.next();
                value = seqStatement.getObject().stringValue();
                value = value.substring(value.lastIndexOf(58) + 1, value.length());
                input.addField(field.getName(), (Object)value);
            }
        }
        return input;
    }

    private void indexJson(SolrInputDocument input, Object object) {
        if (object instanceof JsonArray) {
            JsonArray array = (JsonArray)object;
            for (int i = 0; i < array.size(); ++i) {
                this.indexJson(input, array.get(i));
            }
        } else {
            JsonObject jsonObject = (JsonObject)object;
            for (String name : jsonObject.keySet()) {
                Object value;
                JsonValue jsonValue = (JsonValue)jsonObject.get((Object)name);
                if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT || jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
                    this.indexJson(input, jsonValue);
                    continue;
                }
                SchemaField field = this.indexedFields.get(name);
                if (field == null) continue;
                switch (jsonValue.getValueType()) {
                    case NULL: {
                        value = null;
                        break;
                    }
                    case STRING: {
                        value = ((JsonString)jsonValue).getString();
                        break;
                    }
                    case NUMBER: {
                        JsonNumber jsonNumber = (JsonNumber)jsonValue;
                        value = jsonNumber.isIntegral() ? (double)jsonNumber.longValue() : jsonNumber.doubleValue();
                        break;
                    }
                    case TRUE: {
                        value = Boolean.TRUE;
                        break;
                    }
                    case FALSE: {
                        value = Boolean.FALSE;
                        break;
                    }
                    default: {
                        value = jsonValue.toString();
                    }
                }
                input.addField(name, value);
            }
        }
    }
}

