/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polygene.index.solr;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import org.apache.polygene.api.activation.ActivatorAdapter;
import org.apache.polygene.api.activation.Activators;
import org.apache.polygene.api.injection.scope.Service;
import org.apache.polygene.api.injection.scope.Uses;
import org.apache.polygene.api.mixin.Mixins;
import org.apache.polygene.api.service.ServiceDescriptor;
import org.apache.polygene.api.service.ServiceReference;
import org.apache.polygene.api.util.AccessibleObjects;
import org.apache.polygene.library.fileconfig.FileConfiguration;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;

@Mixins(value={Mixin.class})
@Activators(value={Activator.class})
public interface EmbeddedSolrService {
    public SolrServer solrServer();

    public SolrCore solrCore();

    public void activateSolr() throws Exception;

    public void passivateSolr() throws Exception;

    public static abstract class Mixin
    implements EmbeddedSolrService {
        @Service
        FileConfiguration fileConfig;
        public CoreContainer coreContainer;
        public EmbeddedSolrServer server;
        @Uses
        ServiceDescriptor descriptor;
        private SolrCore core;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activateSolr() throws Exception {
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                File directory = new File(this.fileConfig.dataDirectory(), this.descriptor.identity().toString());
                directory.mkdirs();
                System.setProperty("solr.solr.home", directory.getAbsolutePath());
                CoreContainer.Initializer initializer = new CoreContainer.Initializer();
                this.coreContainer = initializer.initialize();
                this.server = new EmbeddedSolrServer(this.coreContainer, "");
                this.core = this.coreContainer.getCore("");
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        @Override
        public void passivateSolr() throws Exception {
            this.core.closeSearcher();
            this.coreContainer.shutdown();
            Field instanceField = SolrCore.class.getDeclaredField("instance");
            ((Field)AccessibleObjects.accessible((AccessibleObject)instanceField)).set(null, null);
            SolrConfig.config = null;
        }

        @Override
        public SolrServer solrServer() {
            return this.server;
        }

        @Override
        public SolrCore solrCore() {
            return this.core;
        }
    }

    public static class Activator
    extends ActivatorAdapter<ServiceReference<EmbeddedSolrService>> {
        public void afterActivation(ServiceReference<EmbeddedSolrService> activated) throws Exception {
            ((EmbeddedSolrService)activated.get()).activateSolr();
        }

        public void beforePassivation(ServiceReference<EmbeddedSolrService> passivating) throws Exception {
            ((EmbeddedSolrService)passivating.get()).passivateSolr();
        }
    }
}

