/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherClientAnchorRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.hslf.model.Hyperlink;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeFactory;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.TextBox;
import org.apache.poi.util.LittleEndian;

public class ShapeGroup
extends Shape {
    public ShapeGroup() {
        this(null, null);
        this._escherContainer = this.createSpContainer(false);
    }

    protected ShapeGroup(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public Shape[] getShapes() {
        List lst = this._escherContainer.getChildRecords();
        ArrayList<Shape> shapeList = new ArrayList<Shape>();
        for (int i = 1; i < lst.size(); ++i) {
            EscherRecord r = (EscherRecord)lst.get(i);
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord container = (EscherContainerRecord)r;
                Shape shape = ShapeFactory.createShape(container, this);
                shape.setSheet(this.getSheet());
                shapeList.add(shape);
                continue;
            }
            this.logger.log(7, (Object)("Shape contained non container escher record, was " + r.getClass().getName()));
        }
        Shape[] shapes = shapeList.toArray(new Shape[shapeList.size()]);
        return shapes;
    }

    public void setAnchor(Rectangle anchor) {
        EscherContainerRecord spContainer = (EscherContainerRecord)this._escherContainer.getChildRecords().get(0);
        EscherClientAnchorRecord clientAnchor = (EscherClientAnchorRecord)ShapeGroup.getEscherChild(spContainer, -4080);
        byte[] header = new byte[16];
        LittleEndian.putUShort((byte[])header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])header, (int)2, (int)0);
        LittleEndian.putInt((byte[])header, (int)4, (int)8);
        clientAnchor.fillFields(header, 0, null);
        clientAnchor.setFlag((short)(anchor.y * 576 / 72));
        clientAnchor.setCol1((short)(anchor.x * 576 / 72));
        clientAnchor.setDx1((short)((anchor.width + anchor.x) * 576 / 72));
        clientAnchor.setRow1((short)((anchor.height + anchor.y) * 576 / 72));
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(spContainer, -4087);
        spgr.setRectX1(anchor.x * 576 / 72);
        spgr.setRectY1(anchor.y * 576 / 72);
        spgr.setRectX2((anchor.x + anchor.width) * 576 / 72);
        spgr.setRectY2((anchor.y + anchor.height) * 576 / 72);
    }

    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spgr = new EscherContainerRecord();
        spgr.setRecordId((short)-4093);
        spgr.setOptions((short)15);
        EscherContainerRecord spcont = new EscherContainerRecord();
        spcont.setRecordId((short)-4092);
        spcont.setOptions((short)15);
        EscherSpgrRecord spg = new EscherSpgrRecord();
        spg.setOptions((short)1);
        spcont.addChildRecord((EscherRecord)spg);
        EscherSpRecord sp = new EscherSpRecord();
        short type = 2;
        sp.setOptions(type);
        sp.setFlags(513);
        spcont.addChildRecord((EscherRecord)sp);
        EscherClientAnchorRecord anchor = new EscherClientAnchorRecord();
        spcont.addChildRecord((EscherRecord)anchor);
        spgr.addChildRecord((EscherRecord)spcont);
        return spgr;
    }

    public void addShape(Shape shape) {
        this._escherContainer.addChildRecord((EscherRecord)shape.getSpContainer());
        Sheet sheet = this.getSheet();
        shape.setSheet(sheet);
        shape.afterInsert(sheet);
        if (shape instanceof TextBox) {
            TextBox tbox = (TextBox)shape;
            this.getSheet().getPPDrawing().addTextboxWrapper(tbox._txtbox);
        }
    }

    public void moveTo(int x, int y) {
        Rectangle anchor = this.getAnchor();
        int dx = x - anchor.x;
        int dy = y - anchor.y;
        anchor.translate(dx, dy);
        this.setAnchor(anchor);
        Shape[] shape = this.getShapes();
        for (int i = 0; i < shape.length; ++i) {
            Rectangle chanchor = shape[i].getAnchor();
            chanchor.translate(dx, dy);
            shape[i].setAnchor(chanchor);
        }
    }

    public Rectangle getAnchor() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpgrRecord spgr = (EscherSpgrRecord)ShapeGroup.getEscherChild(groupInfoContainer, -4087);
        Rectangle anchor = null;
        anchor = new Rectangle();
        anchor.x = spgr.getRectX1() * 72 / 576;
        anchor.y = spgr.getRectY1() * 72 / 576;
        anchor.width = (spgr.getRectX2() - spgr.getRectX1()) * 72 / 576;
        anchor.height = (spgr.getRectY2() - spgr.getRectY1()) * 72 / 576;
        return anchor;
    }

    public int getShapeType() {
        EscherContainerRecord groupInfoContainer = (EscherContainerRecord)this._escherContainer.getChild(0);
        EscherSpRecord spRecord = groupInfoContainer.getChildById((short)-4086);
        return spRecord.getOptions() >> 4;
    }

    public Hyperlink getHyperlink() {
        return null;
    }
}

