/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xwpf.usermodel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.common.usermodel.PictureType;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public final class SimpleImages {
    private SimpleImages() {
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        try (XWPFDocument doc = new XWPFDocument();){
            XWPFParagraph p = doc.createParagraph();
            XWPFRun r = p.createRun();
            for (String imgFile : args) {
                PictureType format;
                if (imgFile.endsWith(".emf")) {
                    format = PictureType.EMF;
                } else if (imgFile.endsWith(".wmf")) {
                    format = PictureType.WMF;
                } else if (imgFile.endsWith(".pict")) {
                    format = PictureType.PICT;
                } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
                    format = PictureType.JPEG;
                } else if (imgFile.endsWith(".png")) {
                    format = PictureType.PNG;
                } else if (imgFile.endsWith(".dib")) {
                    format = PictureType.DIB;
                } else if (imgFile.endsWith(".gif")) {
                    format = PictureType.GIF;
                } else if (imgFile.endsWith(".tiff")) {
                    format = PictureType.TIFF;
                } else if (imgFile.endsWith(".eps")) {
                    format = PictureType.EPS;
                } else if (imgFile.endsWith(".bmp")) {
                    format = PictureType.BMP;
                } else if (imgFile.endsWith(".wpg")) {
                    format = PictureType.WPG;
                } else {
                    System.err.println("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
                    continue;
                }
                r.setText(imgFile);
                r.addBreak();
                try (FileInputStream is = new FileInputStream(imgFile);){
                    r.addPicture((InputStream)is, format, imgFile, Units.toEMU((double)200.0), Units.toEMU((double)200.0));
                }
                r.addBreak(BreakType.PAGE);
            }
            try (FileOutputStream out = new FileOutputStream("images.docx");){
                doc.write((OutputStream)out);
            }
        }
    }
}

