/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Chart;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.charts.AxisPosition;
import org.apache.poi.ss.usermodel.charts.ChartAxis;
import org.apache.poi.ss.usermodel.charts.ChartData;
import org.apache.poi.ss.usermodel.charts.ChartLegend;
import org.apache.poi.ss.usermodel.charts.LegendPosition;
import org.apache.poi.ss.usermodel.charts.ScatterChartData;
import org.apache.poi.ss.usermodel.charts.ValueAxis;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.DataMarker;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ScatterChart {
    public static void main(String[] args) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        CreationHelper creationHelper = wb.getCreationHelper();
        Sheet sheet = wb.createSheet("Sheet 1");
        int NUM_OF_ROWS = 3;
        int NUM_OF_COLUMNS = 10;
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            Row row = sheet.createRow((int)((short)rowIndex));
            for (int colIndex = 0; colIndex < 10; ++colIndex) {
                Cell cell = row.createCell((int)((short)colIndex));
                cell.setCellValue((double)(colIndex * (rowIndex + 1)));
            }
        }
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, 0, 5, 10, 15);
        Chart chart = drawing.createChart(anchor);
        ChartLegend legend = chart.getOrCreateLegend();
        legend.setPosition(LegendPosition.TOP_RIGHT);
        ScatterChartData data = chart.getChartDataFactory().createScatterChartData();
        ValueAxis bottomAxis = chart.getChartAxisFactory().createValueAxis(AxisPosition.BOTTOM);
        ValueAxis leftAxis = chart.getChartAxisFactory().createValueAxis(AxisPosition.LEFT);
        DataMarker xMarker = new DataMarker(sheet, new CellRangeAddress(0, 0, 0, 9));
        DataMarker y1Marker = new DataMarker(sheet, new CellRangeAddress(1, 1, 0, 9));
        DataMarker y2Marker = new DataMarker(sheet, new CellRangeAddress(2, 2, 0, 9));
        data.addSerie(xMarker, y1Marker);
        data.addSerie(xMarker, y2Marker);
        chart.plot((ChartData)data, new ChartAxis[]{bottomAxis, leftAxis});
        FileOutputStream fileOut = new FileOutputStream("ooxml-scatter-chart.xlsx");
        wb.write((OutputStream)fileOut);
        fileOut.close();
    }
}

