/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.examples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EmeddedObjects {
    public static void main(String[] args) throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem((InputStream)new FileInputStream(args[0]));
        HSSFWorkbook workbook = new HSSFWorkbook(fs);
        for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName = obj.getOLE2ClassName();
            if (oleName.equals("Worksheet")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, fs, false);
                embeddedWorkbook.close();
                continue;
            }
            if (oleName.equals("Document")) {
                dn = (DirectoryNode)obj.getDirectory();
                HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                continue;
            }
            if (oleName.equals("Presentation")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSLFSlideShow embeddedPowerPointDocument = new HSLFSlideShow(new HSLFSlideShowImpl(dn));
                continue;
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                Iterator entries = dn.getEntries();
                while (entries.hasNext()) {
                    Entry entry = (Entry)entries.next();
                }
                continue;
            }
            byte[] objectData = obj.getObjectData();
        }
        workbook.close();
    }
}

