/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hslf.model.OLEShape;
import org.apache.poi.hslf.usermodel.HSLFObjectData;
import org.apache.poi.hslf.usermodel.HSLFPictureShape;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSoundData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;

public final class DataExtraction {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            DataExtraction.usage();
            return;
        }
        FileInputStream is = new FileInputStream(args[0]);
        HSLFSlideShow ppt = new HSLFSlideShow((InputStream)is);
        is.close();
        HSLFSoundData[] sound = ppt.getSoundData();
        for (int i = 0; i < sound.length; ++i) {
            String type = sound[i].getSoundType();
            String name = sound[i].getSoundName();
            byte[] data = sound[i].getData();
            FileOutputStream out = new FileOutputStream(name + type);
            out.write(data);
            out.close();
        }
        int oleIdx = -1;
        int picIdx = -1;
        for (HSLFSlide slide : ppt.getSlides()) {
            for (HSLFShape shape : slide.getShapes()) {
                FileOutputStream out;
                HSLFObjectData data;
                if (shape instanceof OLEShape) {
                    int count;
                    ++oleIdx;
                    OLEShape ole = (OLEShape)shape;
                    data = ole.getObjectData();
                    String name = ole.getInstanceName();
                    if ("Worksheet".equals(name)) {
                        HSSFWorkbook wb = new HSSFWorkbook(data.getData());
                        continue;
                    }
                    if ("Document".equals(name)) {
                        HWPFDocument doc = new HWPFDocument(data.getData());
                        Range r = doc.getRange();
                        for (int k = 0; k < r.numParagraphs(); ++k) {
                            Paragraph p = r.getParagraph(k);
                            System.out.println(p.text());
                        }
                        FileOutputStream out2 = new FileOutputStream(name + "-(" + oleIdx + ").doc");
                        doc.write((OutputStream)out2);
                        out2.close();
                        continue;
                    }
                    out = new FileOutputStream(ole.getProgID() + "-" + (oleIdx + 1) + ".dat");
                    InputStream dis = data.getData();
                    byte[] chunk = new byte[2048];
                    while ((count = dis.read(chunk)) >= 0) {
                        out.write(chunk, 0, count);
                    }
                    is.close();
                    out.close();
                    continue;
                }
                if (!(shape instanceof HSLFPictureShape)) continue;
                HSLFPictureShape p = (HSLFPictureShape)shape;
                data = p.getPictureData();
                String ext = data.getType().extension;
                out = new FileOutputStream("pict-" + ++picIdx + ext);
                out.write(data.getData());
                out.close();
            }
        }
    }

    private static void usage() {
        System.out.println("Usage: DataExtraction  ppt");
    }
}

