/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StringUtils {
    private StringUtils() {
    }

    public static String replace(String source, String pattern, String replace) {
        if (source == null || source.length() == 0 || pattern == null || pattern.length() == 0) {
            return source;
        }
        int k = source.indexOf(pattern);
        if (k == -1) {
            return source;
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        int l = pattern.length();
        while (k != -1) {
            out.append(source.substring(i, k));
            if (replace != null) {
                out.append(replace);
            }
            i = k + l;
            k = source.indexOf(pattern, i);
        }
        out.append(source.substring(i));
        return out.toString();
    }

    public static String[] copy(String[] source) {
        if (source == null) {
            return null;
        }
        int length = source.length;
        String[] result = new String[length];
        System.arraycopy(source, 0, result, 0, length);
        return result;
    }

    public static Map copyParameters(Map parameters) {
        HashMap result = new HashMap(parameters);
        Iterator it = result.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("Parameter map keys must not be null and of type java.lang.String.");
            }
            try {
                entry.setValue(StringUtils.copy((String[])entry.getValue()));
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException("Parameter map values must not be null and of type java.lang.String[].");
            }
        }
        return result;
    }

    public static String getMimeTypeWithoutEncoding(String mimeType) {
        int index = mimeType.indexOf(59);
        String strippedType = null;
        strippedType = index == -1 ? mimeType : mimeType.substring(0, index);
        return strippedType.trim();
    }
}

