/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.PortletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.internal.InternalPortletResponse;
import org.apache.pluto.internal.InternalPortletWindow;
import org.apache.pluto.spi.ResourceURLProvider;
import org.apache.pluto.util.ArgumentUtility;
import org.apache.pluto.util.PrintWriterServletOutputStream;

public abstract class PortletResponseImpl
extends HttpServletResponseWrapper
implements PortletResponse,
InternalPortletResponse {
    private final PortletContainer container;
    private final InternalPortletWindow internalPortletWindow;
    private final HttpServletRequest httpServletRequest;
    private boolean usingWriter;
    private boolean usingStream;
    private ServletOutputStream wrappedWriter;

    public PortletResponseImpl(PortletContainer container, InternalPortletWindow internalPortletWindow, HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        super(servletResponse);
        this.container = container;
        this.httpServletRequest = servletRequest;
        this.internalPortletWindow = internalPortletWindow;
    }

    public void addProperty(String name, String value) {
        ArgumentUtility.validateNotNull("propertyName", name);
        this.container.getRequiredContainerServices().getPortalCallbackService().addResponseProperty(this.getHttpServletRequest(), this.internalPortletWindow, name, value);
    }

    public void setProperty(String name, String value) {
        ArgumentUtility.validateNotNull("propertyName", name);
        this.container.getRequiredContainerServices().getPortalCallbackService().setResponseProperty(this.getHttpServletRequest(), this.internalPortletWindow, name, value);
    }

    public String encodeURL(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument to encodeURL must not be null.");
        }
        String wsrpRewriteToken = "wsrp_rewrite?";
        if (path.indexOf("://") == -1 && !path.startsWith("/") && !path.startsWith("wsrp_rewrite?")) {
            throw new IllegalArgumentException("only absolute URLs or full path URIs are allowed");
        }
        ResourceURLProvider provider = this.getContainer().getRequiredContainerServices().getPortalCallbackService().getResourceURLProvider(this.httpServletRequest, this.internalPortletWindow);
        if (this.isAbsolute(path)) {
            provider.setAbsoluteURL(path);
        } else {
            provider.setFullPath(path);
        }
        return this.getHttpServletResponse().encodeURL(((Object)provider).toString());
    }

    public InternalPortletWindow getInternalPortletWindow() {
        return this.internalPortletWindow;
    }

    protected PortletContainer getContainer() {
        return this.container;
    }

    protected HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    protected boolean isAbsolute(String path) {
        String wsrpToken = "wsrp_rewrite?";
        String schemeToken = "://";
        if (path == null) {
            return false;
        }
        if (path.indexOf("://") != -1) {
            return true;
        }
        return path.startsWith("wsrp_rewrite?");
    }

    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException, IOException {
        if (this.usingWriter) {
            throw new IllegalStateException("getPortletOutputStream can't be used after getWriter was invoked.");
        }
        if (this.wrappedWriter == null) {
            this.wrappedWriter = new PrintWriterServletOutputStream(this.getHttpServletResponse().getWriter());
        }
        this.usingStream = true;
        return this.wrappedWriter;
    }

    public PrintWriter getWriter() throws IllegalStateException, IOException {
        if (this.usingStream) {
            throw new IllegalStateException("getWriter can't be used after getOutputStream was invoked.");
        }
        this.usingWriter = true;
        return this.getHttpServletResponse().getWriter();
    }
}

