/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.test.parserserializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.test.parserserializer.exceptions.ParserSerializerTestsuiteException;
import org.apache.plc4x.test.parserserializer.model.ParserSerializerTestsuite;
import org.apache.plc4x.test.parserserializer.model.Testcase;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class ParserSerializerTestsuiteRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserSerializerTestsuiteRunner.class);
    private final String testsuiteDocument;

    public ParserSerializerTestsuiteRunner(String testsuiteDocument) {
        this.testsuiteDocument = testsuiteDocument;
    }

    @TestFactory
    public Iterable<DynamicTest> getTestsuiteTests() throws ParserSerializerTestsuiteException {
        ParserSerializerTestsuite testSuite = this.parseTestsuite(ParserSerializerTestsuiteRunner.class.getResourceAsStream(this.testsuiteDocument));
        LinkedList<DynamicTest> dynamicTests = new LinkedList<DynamicTest>();
        for (Testcase testcase : testSuite.getTestcases()) {
            String testcaseName = testcase.getName();
            String testcaseLabel = testSuite.getName() + ": " + testcaseName;
            DynamicTest test = DynamicTest.dynamicTest((String)testcaseLabel, () -> this.run(testSuite, testcase));
            dynamicTests.add(test);
        }
        return dynamicTests;
    }

    private ParserSerializerTestsuite parseTestsuite(InputStream testsuiteDocumentXml) throws ParserSerializerTestsuiteException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(testsuiteDocumentXml);
            Element testsuiteXml = document.getRootElement();
            boolean littleEndian = !"true".equals(testsuiteXml.attributeValue("bigEndian"));
            Element testsuiteName = testsuiteXml.element(new QName("name"));
            List testcasesXml = testsuiteXml.elements(new QName("testcase"));
            ArrayList<Testcase> testcases = new ArrayList<Testcase>(testcasesXml.size());
            for (Element testcaseXml : testcasesXml) {
                Element nameElement = testcaseXml.element(new QName("name"));
                Element descriptionElement = testcaseXml.element(new QName("description"));
                Element rawElement = testcaseXml.element(new QName("raw"));
                Element rootTypeElement = testcaseXml.element(new QName("root-type"));
                Element parserArgumentsElement = testcaseXml.element(new QName("parser-arguments"));
                Element xmlElement = testcaseXml.element(new QName("xml"));
                String name = nameElement.getTextTrim();
                String description = descriptionElement != null ? descriptionElement.getTextTrim() : null;
                byte[] raw = Hex.decodeHex((String)rawElement.getTextTrim());
                String rootType = rootTypeElement.getTextTrim();
                LinkedList<String> parserArguments = new LinkedList<String>();
                if (parserArgumentsElement != null) {
                    for (Element element : parserArgumentsElement.elements()) {
                        parserArguments.add(element.getTextTrim());
                    }
                }
                testcases.add(new Testcase(name, description, raw, rootType, parserArguments, xmlElement));
            }
            LOGGER.info(String.format("Found %d testcases.", testcases.size()));
            return new ParserSerializerTestsuite(testsuiteName.getTextTrim(), testcases, littleEndian);
        }
        catch (DocumentException e) {
            throw new ParserSerializerTestsuiteException("Error parsing testsuite xml", e);
        }
        catch (DecoderException e) {
            throw new ParserSerializerTestsuiteException("Error parsing testcase raw data", e);
        }
    }

    private void run(ParserSerializerTestsuite testSuite, Testcase testcase) throws ParserSerializerTestsuiteException {
        ObjectMapper mapper = new XmlMapper().enableDefaultTyping();
        ReadBuffer readBuffer = new ReadBuffer(testcase.getRaw(), testSuite.isLittleEndian());
        String referenceXml = ((Element)testcase.getXml().elements().get(0)).asXML();
        MessageIO messageIO = this.getMessageIOForTestcase(testcase);
        try {
            Object msg = messageIO.parse(readBuffer, testcase.getParserArguments().toArray());
            String xmlString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(msg);
            Diff diff = DiffBuilder.compare((Object)referenceXml).withTest((Object)xmlString).ignoreComments().ignoreWhitespace().build();
            if (diff.hasDifferences()) {
                System.out.println(xmlString);
                throw new ParserSerializerTestsuiteException("Differences were found after parsing.\n" + diff.toString());
            }
            WriteBuffer writeBuffer = new WriteBuffer(((Message)msg).getLengthInBytes(), testSuite.isLittleEndian());
            messageIO.serialize(writeBuffer, msg, new Object[0]);
            byte[] data = writeBuffer.getData();
            if (testcase.getRaw().length != data.length) {
                LOGGER.info("Expected a byte array with a length of " + testcase.getRaw().length + " but got one with " + data.length);
            }
            if (!Arrays.equals(testcase.getRaw(), data)) {
                int i;
                for (i = 0; i < data.length && data[i] == testcase.getRaw()[i]; ++i) {
                }
                throw new ParserSerializerTestsuiteException("Differences were found after serializing.\nExpected: " + Hex.encodeHexString((byte[])testcase.getRaw()) + "\nBut Got:  " + Hex.encodeHexString((byte[])data) + "\n          " + String.join((CharSequence)"", Collections.nCopies(i, "--")) + "^");
            }
        }
        catch (ParseException e) {
            throw new ParserSerializerTestsuiteException("Unable to parse message", e);
        }
        catch (JsonProcessingException e) {
            throw new ParserSerializerTestsuiteException("Unable to serialize parsed message as XML string", e);
        }
    }

    private MessageIO getMessageIOForTestcase(Testcase testcase) throws ParserSerializerTestsuiteException {
        String className = ((Element)testcase.getXml().elements().get(0)).attributeValue(new QName("className"));
        String ioRootClassName = className.substring(0, className.lastIndexOf(46) + 1) + testcase.getRootType();
        String ioClassName = className.substring(0, className.lastIndexOf(46) + 1) + "io." + testcase.getRootType() + "IO";
        try {
            Class<?> ioRootClass = Class.forName(ioRootClassName);
            Class<?> ioClass = Class.forName(ioClassName);
            Method parseMethodTmp = null;
            Method serializeMethodTmp = null;
            final LinkedList parameterTypes = new LinkedList();
            for (Method method : ioClass.getMethods()) {
                if (method.getName().equals("staticParse") && Modifier.isStatic(method.getModifiers()) && method.getReturnType() == ioRootClass) {
                    parseMethodTmp = method;
                    for (int i = 1; i < method.getParameterCount(); ++i) {
                        Class<?> parameterType = parseMethodTmp.getParameterTypes()[i];
                        parameterTypes.add(parameterType);
                    }
                }
                if (!method.getName().equals("staticSerialize") || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes()[1] != ioRootClass) continue;
                serializeMethodTmp = method;
            }
            if (parseMethodTmp == null || serializeMethodTmp == null) {
                throw new ParserSerializerTestsuiteException("Unable to instantiate IO component. Missing static parse or serialize methods.");
            }
            final Method parseMethod = parseMethodTmp;
            final Method serializeMethod = serializeMethodTmp;
            return new MessageIO(){

                public Object parse(ReadBuffer io, Object ... args) throws ParseException {
                    try {
                        Object[] argValues = new Object[args.length + 1];
                        argValues[0] = io;
                        for (int i = 1; i <= args.length; ++i) {
                            String parameterValue = (String)args[i - 1];
                            Class parameterType = (Class)parameterTypes.get(i - 1);
                            if (parameterType == Boolean.class) {
                                argValues[i] = Boolean.parseBoolean(parameterValue);
                                continue;
                            }
                            if (parameterType == Byte.class) {
                                argValues[i] = Byte.parseByte(parameterValue);
                                continue;
                            }
                            if (parameterType == Short.class) {
                                argValues[i] = Short.parseShort(parameterValue);
                                continue;
                            }
                            if (parameterType == Integer.class) {
                                argValues[i] = Integer.parseInt(parameterValue);
                                continue;
                            }
                            if (parameterType == Long.class) {
                                argValues[i] = Long.parseLong(parameterValue);
                                continue;
                            }
                            if (parameterType == Float.class) {
                                argValues[i] = Float.valueOf(Float.parseFloat(parameterValue));
                                continue;
                            }
                            if (parameterType == Double.class) {
                                argValues[i] = Double.parseDouble(parameterValue);
                                continue;
                            }
                            if (parameterType == String.class) {
                                argValues[i] = parameterValue;
                                continue;
                            }
                            throw new ParseException("Currently unsupported parameter type");
                        }
                        return parseMethod.invoke(null, argValues);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ParseException("error parsing", (Throwable)e);
                    }
                }

                public void serialize(WriteBuffer io, Object value, Object ... args) throws ParseException {
                    try {
                        serializeMethod.invoke(null, io, value);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ParseException("error serializing", (Throwable)e);
                    }
                }
            };
        }
        catch (ClassNotFoundException e) {
            throw new ParserSerializerTestsuiteException("Unable to instantiate IO component", e);
        }
    }
}

