/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.test.driver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.embedded.Plc4xEmbeddedChannel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.plc4x.java.PlcDriverManager;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.spi.connection.ChannelExposingConnection;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageIO;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.test.driver.exceptions.DriverTestsuiteException;
import org.apache.plc4x.test.driver.model.DriverTestsuite;
import org.apache.plc4x.test.driver.model.StepType;
import org.apache.plc4x.test.driver.model.TestStep;
import org.apache.plc4x.test.driver.model.Testcase;
import org.apache.plc4x.test.driver.model.api.TestField;
import org.apache.plc4x.test.driver.model.api.TestReadRequest;
import org.apache.plc4x.test.driver.model.api.TestRequest;
import org.apache.plc4x.test.driver.model.api.TestWriteRequest;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.Diff;

public class DriverTestsuiteRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverTestsuiteRunner.class);
    private final String testsuiteDocument;
    private CompletableFuture<? extends PlcResponse> responseFuture;

    public DriverTestsuiteRunner(String testsuiteDocument) {
        this.testsuiteDocument = testsuiteDocument;
    }

    @TestFactory
    public Iterable<DynamicTest> getTestsuiteTests() throws DriverTestsuiteException {
        DriverTestsuite testSuite = this.parseTestsuite(DriverTestsuiteRunner.class.getResourceAsStream(this.testsuiteDocument));
        LinkedList<DynamicTest> dynamicTests = new LinkedList<DynamicTest>();
        for (Testcase testcase : testSuite.getTestcases()) {
            String testcaseName = testcase.getName();
            String testcaseLabel = testSuite.getName() + ": " + testcaseName;
            DynamicTest test = DynamicTest.dynamicTest((String)testcaseLabel, () -> this.run(testSuite, testcase));
            dynamicTests.add(test);
        }
        return dynamicTests;
    }

    private DriverTestsuite parseTestsuite(InputStream testsuiteDocumentXml) throws DriverTestsuiteException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(testsuiteDocumentXml);
            Element testsuiteXml = document.getRootElement();
            boolean bigEndian = !"false".equals(testsuiteXml.attributeValue("bigEndian"));
            String testsuiteName = testsuiteXml.element(new QName("name")).getTextTrim();
            String driverName = testsuiteXml.element(new QName("driver-name")).getTextTrim();
            Element driverParametersElement = testsuiteXml.element(new QName("driver-parameters"));
            HashMap<String, String> driverParameters = null;
            if (driverParametersElement != null) {
                driverParameters = new HashMap<String, String>();
                for (Element parameter : driverParametersElement.elements(new QName("parameter"))) {
                    String parameterName = parameter.element(new QName("name")).getTextTrim();
                    String parameterValue = parameter.element(new QName("value")).getTextTrim();
                    driverParameters.put(parameterName, parameterValue);
                }
            }
            LinkedList<TestStep> setupSteps = new LinkedList<TestStep>();
            if (testsuiteXml.element(new QName("setup")) != null) {
                Element setupElement = testsuiteXml.element(new QName("setup"));
                for (Object element : setupElement.elements()) {
                    setupSteps.add(this.parseTestStep((Element)element));
                }
            }
            LinkedList<TestStep> teardownSteps = new LinkedList<TestStep>();
            if (testsuiteXml.element(new QName("teardown")) != null) {
                Element teardownElement = testsuiteXml.element(new QName("teardown"));
                for (Element element : teardownElement.elements()) {
                    setupSteps.add(this.parseTestStep(element));
                }
            }
            List testcasesXml = testsuiteXml.elements(new QName("testcase"));
            ArrayList<Testcase> testcases = new ArrayList<Testcase>(testcasesXml.size());
            for (Element testcaseXml : testcasesXml) {
                Element nameElement = testcaseXml.element(new QName("name"));
                Element descriptionElement = testcaseXml.element(new QName("description"));
                Element stepsElement = testcaseXml.element(new QName("steps"));
                String name = nameElement.getTextTrim();
                String description = descriptionElement != null ? descriptionElement.getTextTrim() : null;
                LinkedList<TestStep> steps = new LinkedList<TestStep>();
                for (Element element : stepsElement.elements()) {
                    steps.add(this.parseTestStep(element));
                }
                testcases.add(new Testcase(name, description, steps));
            }
            LOGGER.info(String.format("Found %d testcases.", testcases.size()));
            System.setProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE", "false");
            PlcConnection connection = this.getConnection(driverName, driverParameters);
            TimeUnit.MILLISECONDS.sleep(200L);
            return new DriverTestsuite(testsuiteName, connection, setupSteps, teardownSteps, testcases, bigEndian);
        }
        catch (DocumentException e) {
            throw new DriverTestsuiteException("Error parsing testsuite xml", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DriverTestsuiteException("Interruption setting up testsuite xml", e);
        }
    }

    private PlcConnection getConnection(String driverName, Map<String, String> driverParameters) throws DriverTestsuiteException {
        try {
            StringBuilder sb = new StringBuilder();
            if (driverParameters != null) {
                for (Map.Entry<String, String> parameter : driverParameters.entrySet()) {
                    sb.append("&").append(parameter.getKey()).append("=").append(parameter.getValue());
                }
            }
            if (sb.length() > 0) {
                sb.replace(0, 1, "?");
            }
            return new PlcDriverManager().getConnection(driverName + ":test://hurz" + sb.toString());
        }
        catch (PlcConnectionException e) {
            throw new DriverTestsuiteException("Error loading driver", e);
        }
    }

    private void run(DriverTestsuite testsuite, Testcase testcase) throws DriverTestsuiteException {
        PlcConnection plcConnection = testsuite.getConnection();
        Plc4xEmbeddedChannel embeddedChannel = this.getEmbeddedChannel(testsuite);
        boolean bigEndian = testsuite.isBigEndian();
        if (!testsuite.getSetupSteps().isEmpty()) {
            LOGGER.info("Running setup steps");
            for (TestStep setupStep : testsuite.getSetupSteps()) {
                this.executeStep(setupStep, plcConnection, embeddedChannel, bigEndian);
            }
            LOGGER.info("Finished setup steps");
        }
        LOGGER.info("Running test steps");
        for (TestStep step : testcase.getSteps()) {
            this.executeStep(step, plcConnection, embeddedChannel, bigEndian);
        }
        LOGGER.info("Finished test steps");
        if (!testsuite.getTeardownSteps().isEmpty()) {
            LOGGER.info("Running teardown steps");
            for (TestStep teardownStep : testsuite.getTeardownSteps()) {
                this.executeStep(teardownStep, plcConnection, embeddedChannel, bigEndian);
            }
            LOGGER.info("Finished teardown steps");
        }
    }

    private void executeStep(TestStep testStep, PlcConnection plcConnection, Plc4xEmbeddedChannel embeddedChannel, boolean bigEndian) throws DriverTestsuiteException {
        LOGGER.info(String.format("  - Running step: '%s' - %s", new Object[]{testStep.getName(), testStep.getType()}));
        ObjectMapper mapper = new XmlMapper().enableDefaultTyping();
        Element payload = testStep.getPayload();
        try {
            switch (testStep.getType()) {
                case OUTGOING_PLC_BYTES: {
                    this.shortDelay();
                    byte[] data = this.getOutboundBytes(embeddedChannel);
                    this.validateBytes(payload, data, bigEndian);
                    break;
                }
                case OUTGOING_PLC_MESSAGE: {
                    this.shortDelay();
                    byte[] data = this.getOutboundBytes(embeddedChannel);
                    this.validateMessage(payload, data, bigEndian);
                    break;
                }
                case INCOMING_PLC_BYTES: 
                case INCOMING_PLC_MESSAGE: {
                    byte[] data = this.getBytesFromXml(payload, bigEndian);
                    embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)});
                    break;
                }
                case API_REQUEST: {
                    String referenceXml = payload.asXML();
                    TestRequest request = (TestRequest)mapper.readValue(referenceXml, TestRequest.class);
                    if (request instanceof TestReadRequest) {
                        TestReadRequest readRequest = (TestReadRequest)request;
                        PlcReadRequest.Builder builder = plcConnection.readRequestBuilder();
                        for (TestField testField : readRequest.getFields()) {
                            builder.addItem(testField.getName(), testField.getAddress());
                        }
                        PlcReadRequest plc4xRequest = builder.build();
                        if (this.responseFuture != null) {
                            throw new DriverTestsuiteException("Previous response not handled.");
                        }
                        this.responseFuture = plc4xRequest.execute();
                        break;
                    }
                    if (!(request instanceof TestWriteRequest)) break;
                    break;
                }
                case API_RESPONSE: {
                    if (this.responseFuture == null) {
                        throw new DriverTestsuiteException("No response expected.");
                    }
                    try {
                        PlcResponse plcResponse = this.responseFuture.get(1000L, TimeUnit.MILLISECONDS);
                        String string = mapper.writeValueAsString((Object)plcResponse);
                        break;
                    }
                    catch (Exception e) {
                        throw new DriverTestsuiteException("Got no response within 1000ms.");
                    }
                }
                case DELAY: {
                    this.delay(1000);
                    break;
                }
                case TERMINATE: {
                    embeddedChannel.close();
                }
            }
        }
        catch (IOException e) {
            throw new DriverTestsuiteException("Error processing the xml", e);
        }
        LOGGER.info("    Done");
    }

    private TestStep parseTestStep(Element curElement) {
        String elementName = curElement.getName();
        StepType stepType = StepType.valueOf(elementName.toUpperCase().replace("-", "_"));
        String stepName = curElement.attributeValue(new QName("name"));
        Element definition = null;
        if (curElement.hasMixedContent()) {
            definition = (Element)curElement.elementIterator().next();
        }
        return new TestStep(stepType, stepName, definition);
    }

    private Plc4xEmbeddedChannel getEmbeddedChannel(DriverTestsuite testSuite) {
        if (testSuite.getConnection() instanceof ChannelExposingConnection) {
            ChannelExposingConnection connection = (ChannelExposingConnection)testSuite.getConnection();
            Channel channel = connection.getChannel();
            if (channel instanceof Plc4xEmbeddedChannel) {
                return (Plc4xEmbeddedChannel)channel;
            }
            throw new PlcRuntimeException("Expecting EmbeddedChannel");
        }
        throw new PlcRuntimeException("Expecting ChannelExposingConnection");
    }

    private Class<? extends Message> getMessageType(String messageClassName) throws DriverTestsuiteException {
        try {
            Class<?> messageClass = Class.forName(messageClassName);
            if (Message.class.isAssignableFrom(messageClass)) {
                return messageClass;
            }
            throw new DriverTestsuiteException("IO class must implement Message interface");
        }
        catch (ClassNotFoundException e) {
            throw new DriverTestsuiteException("Error loading message class", e);
        }
    }

    private Class<? extends MessageIO<?, ?>> getMessageIOType(String messageClassName) throws DriverTestsuiteException {
        String ioClassName = messageClassName.substring(0, messageClassName.lastIndexOf(46)) + ".io." + messageClassName.substring(messageClassName.lastIndexOf(46) + 1) + "IO";
        try {
            Class<?> ioClass = Class.forName(ioClassName);
            if (MessageIO.class.isAssignableFrom(ioClass)) {
                return ioClass;
            }
            throw new DriverTestsuiteException("IO class muss implement MessageIO interface");
        }
        catch (ClassNotFoundException e) {
            throw new DriverTestsuiteException("Error loading io class", e);
        }
    }

    private byte[] getOutboundBytes(Plc4xEmbeddedChannel embeddedChannel) throws DriverTestsuiteException {
        ByteBuf byteBuf = null;
        for (int i = 0; i < 10 && (byteBuf = (ByteBuf)embeddedChannel.readOutbound()) == null; ++i) {
            this.delay(10);
        }
        if (byteBuf == null) {
            throw new DriverTestsuiteException("No outbound message available within 100ms");
        }
        byte[] data = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(data);
        return data;
    }

    private byte[] getBytesFromXml(Element referenceXml, boolean bigEndian) throws DriverTestsuiteException {
        String className = referenceXml.attributeValue(new QName("className"));
        WriteBuffer writeBuffer = new WriteBuffer(1024, !bigEndian);
        try {
            MessageIO<?, ?> messageIO = this.getMessageIOType(className).newInstance();
            String referenceXmlString = referenceXml.asXML();
            ObjectMapper mapper = new XmlMapper().enableDefaultTyping();
            Message message = (Message)mapper.readValue(referenceXmlString, this.getMessageType(className));
            try {
                messageIO.serialize(writeBuffer, (Object)message, new Object[0]);
                byte[] data = new byte[message.getLengthInBytes()];
                System.arraycopy(writeBuffer.getData(), 0, data, 0, writeBuffer.getPos());
                return data;
            }
            catch (ParseException e) {
                throw new DriverTestsuiteException("Error serializing message", e);
            }
        }
        catch (JsonProcessingException | IllegalAccessException | InstantiationException e) {
            throw new DriverTestsuiteException("Error parsing message", e);
        }
    }

    private void validateBytes(Element referenceXml, byte[] data, boolean bigEndian) throws DriverTestsuiteException {
    }

    private void validateMessage(Element referenceXml, byte[] data, boolean bigEndian) throws DriverTestsuiteException {
        ObjectMapper mapper = new XmlMapper().enableDefaultTyping();
        ReadBuffer readBuffer = new ReadBuffer(data, !bigEndian);
        try {
            String className = referenceXml.attributeValue(new QName("className"));
            MessageIO<?, ?> messageIO = this.getMessageIOType(className).newInstance();
            Object parsedOutput = messageIO.parse(readBuffer, new Object[0]);
            String xmlString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(parsedOutput);
            String referenceXmlString = referenceXml.asXML();
            Diff diff = DiffBuilder.compare((Object)referenceXmlString).withTest((Object)xmlString).ignoreComments().ignoreWhitespace().build();
            if (diff.hasDifferences()) {
                LOGGER.warn(xmlString);
                throw new DriverTestsuiteException("Differences were found after parsing.\n" + diff.toString());
            }
        }
        catch (JsonProcessingException | IllegalAccessException | InstantiationException | ParseException e) {
            throw new DriverTestsuiteException("Error parsing message", e);
        }
    }

    private void shortDelay() throws DriverTestsuiteException {
        this.delay(23);
    }

    private void delay(int milliseconds) throws DriverTestsuiteException {
        try {
            TimeUnit.MILLISECONDS.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DriverTestsuiteException("Interrupted during delay.");
        }
    }
}

