/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.pcap4j.core.Pcaps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequirePcapCondition
implements ExecutionCondition {
    private static final Logger logger = LoggerFactory.getLogger(RequirePcapCondition.class);

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext extensionContext) {
        try {
            String libVersion = Pcaps.libVersion();
            Pattern pattern = Pattern.compile("^libpcap version (?<version>\\d+\\.\\d+(\\.\\d+)?).*$");
            Matcher matcher = pattern.matcher(libVersion);
            if (matcher.matches()) {
                String versionString = matcher.group("version");
                return ConditionEvaluationResult.enabled((String)("Found libpcap version " + versionString));
            }
        }
        catch (Throwable e) {
            logger.info("Error detecting libpcap version.", e);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return ConditionEvaluationResult.disabled((String)"Test disabled due to missing or invalid WinPcap version. Please install from here: https://sourceforge.net/projects/winpcap413-176/ as this version supports all needed features.");
        }
        return ConditionEvaluationResult.disabled((String)"Test disabled due to missing or invalid libpcap version. Please install at least version 1.1.0 to support all features.");
    }
}

