/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcLTIME
extends PlcSimpleValue<Duration> {
    public static PlcLTIME of(Object value) {
        if (value instanceof Duration) {
            return new PlcLTIME((Duration)value);
        }
        if (value instanceof Integer) {
            return new PlcLTIME(Duration.of((Long)value, ChronoUnit.MILLIS));
        }
        if (value instanceof Long) {
            return new PlcLTIME(Duration.of((Long)value, ChronoUnit.NANOS));
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcLTIME(@JsonProperty(value="value") Duration value) {
        super(value, true);
    }

    public PlcLTIME(@JsonProperty(value="value") Integer value) {
        super(Duration.of(value.intValue(), ChronoUnit.NANOS), true);
    }

    public PlcLTIME(@JsonProperty(value="value") Long value) {
        super(Duration.of(value, ChronoUnit.NANOS), true);
    }

    public PlcLTIME(@JsonProperty(value="value") BigInteger value) {
        super(Duration.of(value.longValue(), ChronoUnit.NANOS), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LTIME;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isDuration() {
        return true;
    }

    @Override
    public int getInteger() {
        return (int)(((Duration)this.value).get(ChronoUnit.NANOS) / 1000000L);
    }

    @Override
    public long getLong() {
        return ((Duration)this.value).get(ChronoUnit.NANOS);
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(((Duration)this.value).get(ChronoUnit.NANOS));
    }

    @Override
    public Duration getDuration() {
        return (Duration)this.value;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return ((Duration)this.value).toString();
    }

    @JsonIgnore
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((Duration)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), valueString, new WithWriterArgs[0]);
    }
}

