/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcIECValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcLINT
extends PlcIECValue<Long> {
    private static final String VALUE_OUT_OF_RANGE = "Value of type %s is out of range %d - %d for a %s Value";
    static Long minValue = Long.MIN_VALUE;
    static Long maxValue = Long.MAX_VALUE;

    public static PlcLINT of(Object value) {
        if (value instanceof Boolean) {
            return new PlcLINT((Boolean)value);
        }
        if (value instanceof Byte) {
            return new PlcLINT((Byte)value);
        }
        if (value instanceof Short) {
            return new PlcLINT((Short)value);
        }
        if (value instanceof Integer) {
            return new PlcLINT((Integer)value);
        }
        if (value instanceof Long) {
            return new PlcLINT((Long)value);
        }
        if (value instanceof Float) {
            return new PlcLINT((Float)value);
        }
        if (value instanceof Double) {
            return new PlcLINT((Double)value);
        }
        if (value instanceof BigInteger) {
            return new PlcLINT((BigInteger)value);
        }
        if (value instanceof BigDecimal) {
            return new PlcLINT((BigDecimal)value);
        }
        return new PlcLINT((String)value);
    }

    public PlcLINT(Boolean value) {
        this.value = value != false ? 1L : 0L;
        this.isNullable = false;
    }

    public PlcLINT(Byte value) {
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcLINT(Short value) {
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcLINT(Integer value) {
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcLINT(Long value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcLINT(Float value) {
        if (value.floatValue() < (float)minValue.longValue() || value.floatValue() > (float)maxValue.longValue() || value.floatValue() % 1.0f != 0.0f) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcLINT(Double value) {
        if (value < (double)minValue.longValue() || value > (double)maxValue.longValue() || value % 1.0 != 0.0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = false;
    }

    public PlcLINT(BigInteger value) {
        if (value.compareTo(BigInteger.valueOf(minValue)) < 0 || value.compareTo(BigInteger.valueOf(maxValue)) > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcLINT(BigDecimal value) {
        if (value.compareTo(BigDecimal.valueOf(minValue)) < 0 || value.compareTo(BigDecimal.valueOf(maxValue)) > 0 || value.scale() > 0) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
        this.value = value.longValue();
        this.isNullable = true;
    }

    public PlcLINT(String value) {
        try {
            this.value = Long.parseLong(value.trim());
            this.isNullable = false;
        }
        catch (Exception e) {
            throw new PlcInvalidFieldException(String.format(VALUE_OUT_OF_RANGE, value, minValue, maxValue, this.getClass().getSimpleName()));
        }
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcLINT(@JsonProperty(value="value") long value) {
        this.value = value;
        this.isNullable = false;
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.LINT;
    }

    @Override
    @JsonIgnore
    public boolean isBoolean() {
        return true;
    }

    @Override
    @JsonIgnore
    public boolean getBoolean() {
        return this.value != null && !((Long)this.value).equals(0L);
    }

    @Override
    @JsonIgnore
    public boolean isByte() {
        return this.value != null && (Long)this.value <= 127L && (Long)this.value >= -128L;
    }

    @Override
    @JsonIgnore
    public byte getByte() {
        return ((Long)this.value).byteValue();
    }

    @Override
    @JsonIgnore
    public boolean isShort() {
        return this.value != null && (Long)this.value <= 32767L && (Long)this.value >= -32768L;
    }

    @Override
    @JsonIgnore
    public short getShort() {
        return ((Long)this.value).shortValue();
    }

    @Override
    @JsonIgnore
    public boolean isInteger() {
        return this.value != null && (Long)this.value <= Integer.MAX_VALUE && (Long)this.value >= Integer.MIN_VALUE;
    }

    @Override
    @JsonIgnore
    public int getInteger() {
        return ((Long)this.value).intValue();
    }

    @Override
    @JsonIgnore
    public boolean isLong() {
        return true;
    }

    @Override
    @JsonIgnore
    public long getLong() {
        return (Long)this.value;
    }

    @Override
    @JsonIgnore
    public boolean isBigInteger() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigInteger getBigInteger() {
        return BigInteger.valueOf((Long)this.value);
    }

    @Override
    @JsonIgnore
    public boolean isFloat() {
        return true;
    }

    @Override
    @JsonIgnore
    public float getFloat() {
        return ((Long)this.value).floatValue();
    }

    @Override
    @JsonIgnore
    public boolean isDouble() {
        return true;
    }

    @Override
    @JsonIgnore
    public double getDouble() {
        return ((Long)this.value).doubleValue();
    }

    @Override
    @JsonIgnore
    public boolean isBigDecimal() {
        return true;
    }

    @Override
    @JsonIgnore
    public BigDecimal getBigDecimal() {
        return BigDecimal.valueOf(this.getDouble());
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return this.toString();
    }

    @JsonIgnore
    public String toString() {
        return Long.toString((Long)this.value);
    }

    @JsonIgnore
    public byte[] getBytes() {
        return new byte[]{(byte)((Long)this.value >> 56 & 0xFFL), (byte)((Long)this.value >> 48 & 0xFFL), (byte)((Long)this.value >> 40 & 0xFFL), (byte)((Long)this.value >> 32 & 0xFFL), (byte)((Long)this.value >> 24 & 0xFFL), (byte)((Long)this.value >> 16 & 0xFFL), (byte)((Long)this.value >> 8 & 0xFFL), (byte)((Long)this.value & 0xFFL)};
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.writeLong(this.getClass().getSimpleName(), 64, (Long)this.value, new WithWriterArgs[0]);
    }
}

