/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcSimpleValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class PlcDATE
extends PlcSimpleValue<LocalDate> {
    public static PlcDATE of(Object value) {
        if (value instanceof LocalDate) {
            return new PlcDATE((LocalDate)value);
        }
        if (value instanceof Long) {
            return new PlcDATE(LocalDateTime.ofInstant(Instant.ofEpochSecond((Long)value), ZoneId.systemDefault()).toLocalDate());
        }
        throw new PlcRuntimeException("Invalid value type");
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") LocalDate value) {
        super(value, true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") Integer value) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond(((long)value.intValue() + 7305L) * 86400L), ZoneId.systemDefault()).toLocalDate(), true);
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public PlcDATE(@JsonProperty(value="value") Long value) {
        super(LocalDateTime.ofInstant(Instant.ofEpochSecond(value), ZoneId.systemDefault()).toLocalDate(), true);
    }

    public PlcValueType getPlcValueType() {
        return PlcValueType.DATE;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public long getLong() {
        Instant instant = ((LocalDate)this.value).atStartOfDay(ZoneId.systemDefault()).toInstant();
        return instant.toEpochMilli() / 1000L;
    }

    @Override
    @JsonIgnore
    public boolean isString() {
        return true;
    }

    @Override
    @JsonIgnore
    public String getString() {
        return ((LocalDate)this.value).toString();
    }

    @Override
    @JsonIgnore
    public boolean isDate() {
        return true;
    }

    @Override
    @JsonIgnore
    public LocalDate getDate() {
        return (LocalDate)this.value;
    }

    @JsonIgnore
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        String valueString = ((LocalDate)this.value).toString();
        writeBuffer.writeString(this.getClass().getSimpleName(), valueString.getBytes(StandardCharsets.UTF_8).length * 8, StandardCharsets.UTF_8.name(), valueString, new WithWriterArgs[0]);
    }
}

