/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.utils.Serializable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public class DefaultPlcSubscriptionResponse
implements PlcSubscriptionResponse,
PlcResponse,
Serializable {
    private final PlcSubscriptionRequest request;
    private final Map<String, ResponseItem<PlcSubscriptionHandle>> values;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public DefaultPlcSubscriptionResponse(@JsonProperty(value="request") PlcSubscriptionRequest request, @JsonProperty(value="values") Map<String, ResponseItem<PlcSubscriptionHandle>> values) {
        this.request = request;
        this.values = values;
        request.getPreRegisteredConsumers().forEach((subscriptionFieldName, consumers) -> {
            PlcSubscriptionHandle subscriptionHandle = this.getSubscriptionHandle((String)subscriptionFieldName);
            if (subscriptionHandle == null) {
                throw new PlcRuntimeException("PlcSubscriptionHandle for " + subscriptionFieldName + " not found");
            }
            consumers.forEach(arg_0 -> ((PlcSubscriptionHandle)subscriptionHandle).register(arg_0));
        });
    }

    @JsonIgnore
    public PlcSubscriptionHandle getSubscriptionHandle(String name) {
        ResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        if (response.getCode() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Item " + name + " failed to subscribe: " + response.getCode());
        }
        return response.getValue();
    }

    @JsonIgnore
    public Collection<String> getFieldNames() {
        return this.values.keySet();
    }

    @JsonIgnore
    public PlcSubscriptionField getField(String name) {
        throw new PlcNotImplementedException("field access not possible as these come async");
    }

    @JsonIgnore
    public PlcResponseCode getResponseCode(String name) {
        ResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        return response.getCode();
    }

    public PlcSubscriptionRequest getRequest() {
        return this.request;
    }

    @JsonIgnore
    public Collection<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.values.values().stream().map(ResponseItem::getValue).collect(Collectors.toList());
    }

    public Map<String, ResponseItem<PlcSubscriptionHandle>> getValues() {
        return this.values;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.pushContext("values", new WithWriterArgs[0]);
        for (Map.Entry<String, ResponseItem<PlcSubscriptionHandle>> valueEntry : this.values.entrySet()) {
            String fieldName = valueEntry.getKey();
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
            ResponseItem<PlcSubscriptionHandle> valueResponse = valueEntry.getValue();
            valueResponse.serialize(writeBuffer);
            writeBuffer.pushContext(fieldName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
    }
}

