/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.connection;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.listener.EventListener;
import org.apache.plc4x.java.spi.Plc4xNettyWrapper;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.GeneratedProtocolMessageCodec;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.MessageInput;

public class CustomProtocolStackConfigurer<BASE_PACKET_CLASS extends Message>
implements ProtocolStackConfigurer<BASE_PACKET_CLASS> {
    private final Class<BASE_PACKET_CLASS> basePacketClass;
    private final ByteOrder byteOrder;
    private final Function<Configuration, ? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol;
    private final Function<Configuration, ? extends DriverContext> driverContext;
    private final Function<Configuration, ? extends MessageInput<BASE_PACKET_CLASS>> protocolIO;
    private final Function<Configuration, ? extends ToIntFunction<ByteBuf>> packetSizeEstimator;
    private final Function<Configuration, ? extends Consumer<ByteBuf>> corruptPacketRemover;
    private final MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;
    private final Object[] parserArgs;

    public static <BPC extends Message> CustomProtocolStackBuilder<BPC> builder(Class<BPC> basePacketClass, Function<Configuration, ? extends MessageInput<BPC>> messageInput) {
        return new CustomProtocolStackBuilder<BPC>(basePacketClass, messageInput);
    }

    CustomProtocolStackConfigurer(Class<BASE_PACKET_CLASS> basePacketClass, ByteOrder byteOrder, Object[] parserArgs, Function<Configuration, ? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol, Function<Configuration, ? extends DriverContext> driverContext, Function<Configuration, ? extends MessageInput<BASE_PACKET_CLASS>> protocolIO, Function<Configuration, ? extends ToIntFunction<ByteBuf>> packetSizeEstimator, Function<Configuration, ? extends Consumer<ByteBuf>> corruptPacketRemover, MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
        this.basePacketClass = basePacketClass;
        this.byteOrder = byteOrder;
        this.parserArgs = parserArgs;
        this.protocol = protocol;
        this.driverContext = driverContext;
        this.protocolIO = protocolIO;
        this.packetSizeEstimator = packetSizeEstimator;
        this.corruptPacketRemover = corruptPacketRemover;
        this.encryptionHandler = encryptionHandler;
    }

    private ChannelHandler getMessageCodec(Configuration configuration) {
        return new GeneratedProtocolMessageCodec<BASE_PACKET_CLASS>(this.basePacketClass, this.protocolIO.apply(configuration), this.byteOrder, this.parserArgs, this.packetSizeEstimator == null ? null : this.packetSizeEstimator.apply(configuration), this.corruptPacketRemover == null ? null : this.corruptPacketRemover.apply(configuration));
    }

    @Override
    public Plc4xProtocolBase<BASE_PACKET_CLASS> configurePipeline(Configuration configuration, ChannelPipeline pipeline, PlcAuthentication authentication, boolean passive, List<EventListener> ignore) {
        if (this.encryptionHandler != null) {
            pipeline.addLast(new ChannelHandler[]{this.encryptionHandler});
        }
        pipeline.addLast(new ChannelHandler[]{this.getMessageCodec(configuration)});
        Plc4xProtocolBase<BASE_PACKET_CLASS> protocol = ConfigurationFactory.configure(configuration, this.protocol.apply(configuration));
        DriverContext driverContext = this.driverContext.apply(configuration);
        if (driverContext != null) {
            protocol.setDriverContext(driverContext);
        }
        Plc4xNettyWrapper<BASE_PACKET_CLASS> context = new Plc4xNettyWrapper<BASE_PACKET_CLASS>(pipeline, passive, protocol, authentication, this.basePacketClass);
        pipeline.addLast(new ChannelHandler[]{context});
        return protocol;
    }

    public static final class CustomProtocolStackBuilder<BASE_PACKET_CLASS extends Message> {
        private final Class<BASE_PACKET_CLASS> basePacketClass;
        private final Function<Configuration, ? extends MessageInput<BASE_PACKET_CLASS>> messageInput;
        private Function<Configuration, ? extends DriverContext> driverContext;
        private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        private Object[] parserArgs;
        private Function<Configuration, ? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol;
        private Function<Configuration, ? extends ToIntFunction<ByteBuf>> packetSizeEstimator;
        private Function<Configuration, ? extends Consumer<ByteBuf>> corruptPacketRemover;
        private MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler;

        public CustomProtocolStackBuilder(Class<BASE_PACKET_CLASS> basePacketClass, Function<Configuration, ? extends MessageInput<BASE_PACKET_CLASS>> messageInput) {
            this.basePacketClass = basePacketClass;
            this.messageInput = messageInput;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withDriverContext(Function<Configuration, ? extends DriverContext> driverContextClass) {
            this.driverContext = driverContextClass;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> byteOrder(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> bigEndian() {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> littleEndian() {
            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withParserArgs(Object ... parserArgs) {
            this.parserArgs = parserArgs;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withProtocol(Function<Configuration, ? extends Plc4xProtocolBase<BASE_PACKET_CLASS>> protocol) {
            this.protocol = protocol;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withPacketSizeEstimator(Function<Configuration, ? extends ToIntFunction<ByteBuf>> packetSizeEstimator) {
            this.packetSizeEstimator = packetSizeEstimator;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withCorruptPacketRemover(Function<Configuration, ? extends Consumer<ByteBuf>> corruptPacketRemover) {
            this.corruptPacketRemover = corruptPacketRemover;
            return this;
        }

        public CustomProtocolStackBuilder<BASE_PACKET_CLASS> withEncryptionHandler(MessageToMessageCodec<ByteBuf, ByteBuf> encryptionHandler) {
            this.encryptionHandler = encryptionHandler;
            return this;
        }

        public CustomProtocolStackConfigurer<BASE_PACKET_CLASS> build() {
            assert (this.protocol != null);
            return new CustomProtocolStackConfigurer<BASE_PACKET_CLASS>(this.basePacketClass, this.byteOrder, this.parserArgs, this.protocol, this.driverContext, this.messageInput, this.packetSizeEstimator, this.corruptPacketRemover, this.encryptionHandler);
        }
    }
}

