/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.util;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.plc4x.java.s7.netty.model.messages.S7RequestMessage;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.S7Payload;
import org.apache.plc4x.java.s7.netty.model.payloads.VarPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.types.VariableAddressingMode;

public class S7RequestSizeCalculator {
    private S7RequestSizeCalculator() {
    }

    public static short getRequestMessageSize(S7RequestMessage requestMessage) {
        short size = 10;
        size = (short)(size + S7RequestSizeCalculator.getRequestParametersSize(requestMessage.getParameters()));
        size = (short)(size + S7RequestSizeCalculator.getRequestPayloadsSize(requestMessage.getPayloads()));
        return size;
    }

    public static short getRequestItemTotalSize(VarParameterItem varParameterItem, VarPayloadItem varPayloadItem) {
        return (short)(S7RequestSizeCalculator.getRequestReadWriteVarParameterItemSize(varParameterItem) + (varPayloadItem != null ? S7RequestSizeCalculator.getRequestWriteVarPayloadItemSize(varPayloadItem) : (short)0));
    }

    private static short getRequestParametersSize(List<S7Parameter> parameters) {
        short l = 0;
        if (parameters != null) {
            for (S7Parameter parameter : parameters) {
                l = (short)(l + S7RequestSizeCalculator.getRequestParameterSize(parameter));
            }
        }
        return l;
    }

    private static short getRequestParameterSize(S7Parameter parameter) {
        switch (parameter.getType()) {
            case READ_VAR: 
            case WRITE_VAR: {
                return S7RequestSizeCalculator.getRequestReadWriteVarParameterSize((VarParameter)parameter);
            }
            case SETUP_COMMUNICATION: {
                return 8;
            }
        }
        throw new NotImplementedException("Not implemented");
    }

    private static short getRequestReadWriteVarParameterSize(VarParameter varParameter) {
        short length = 2;
        for (VarParameterItem varParameterItem : varParameter.getItems()) {
            length = (short)(length + S7RequestSizeCalculator.getRequestReadWriteVarParameterItemSize(varParameterItem));
        }
        return length;
    }

    private static short getRequestReadWriteVarParameterItemSize(VarParameterItem varParameterItem) {
        VariableAddressingMode addressMode = varParameterItem.getAddressingMode();
        if (addressMode == VariableAddressingMode.S7ANY) {
            return 12;
        }
        throw new NotImplementedException("Not implemented");
    }

    private static short getRequestPayloadsSize(List<S7Payload> payloads) {
        short l = 0;
        if (payloads != null) {
            for (S7Payload payload : payloads) {
                l = (short)(l + S7RequestSizeCalculator.getRequestPayloadSize(payload));
            }
        }
        return l;
    }

    private static short getRequestPayloadSize(S7Payload payload) {
        switch (payload.getType()) {
            case WRITE_VAR: {
                return S7RequestSizeCalculator.getRequestWriteVarPayloadSize((VarPayload)payload);
            }
        }
        throw new NotImplementedException("Not implemented");
    }

    private static short getRequestWriteVarPayloadSize(VarPayload varPayload) {
        short length = 0;
        for (VarPayloadItem varPayloadItem : varPayload.getItems()) {
            length = (short)(length + S7RequestSizeCalculator.getRequestWriteVarPayloadItemSize(varPayloadItem));
        }
        return length;
    }

    private static short getRequestWriteVarPayloadItemSize(VarPayloadItem varPayloadItem) {
        short length = 4;
        length = (short)(length + varPayloadItem.getData().length);
        if (varPayloadItem.getDataTransportSize().isSizeInBits()) {
            length = (short)(length + 1);
        }
        return length;
    }
}

