/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.util;

import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.plc4x.java.api.exceptions.PlcInvalidFieldException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.base.connection.DefaultPlcFieldHandler;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBigIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultDoubleFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultFloatFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultLocalDateTimeFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultLongFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultShortFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultStringFieldItem;
import org.apache.plc4x.java.s7.model.S7Field;

public class S7PlcFieldHandler
extends DefaultPlcFieldHandler {
    public PlcField createField(String fieldQuery) {
        if (S7Field.matches(fieldQuery)) {
            return S7Field.of(fieldQuery);
        }
        throw new PlcInvalidFieldException(fieldQuery);
    }

    public BaseDefaultFieldItem encodeBoolean(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case BOOL: 
            case BYTE: 
            case WORD: 
            case DWORD: 
            case LWORD: {
                return this.internalEncodeBoolean(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeByte(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case BYTE: 
            case SINT: 
            case USINT: 
            case CHAR: {
                return this.internalEncodeInteger(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeShort(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case WORD: 
            case INT: 
            case UINT: {
                return this.internalEncodeInteger(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeInteger(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case DWORD: 
            case DINT: 
            case UDINT: {
                return this.internalEncodeInteger(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeBigInteger(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case DWORD: 
            case DINT: 
            case UDINT: {
                return this.internalEncodeInteger(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeLong(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case LWORD: 
            case LINT: 
            case ULINT: {
                return this.internalEncodeInteger(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeFloat(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case REAL: {
                return this.internalEncodeFloatingPoint(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeDouble(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case LREAL: {
                return this.internalEncodeFloatingPoint(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeString(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case CHAR: 
            case WCHAR: 
            case STRING: 
            case WSTRING: {
                return this.internalEncodeString(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeTime(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case TIME: {
                return this.internalEncodeTemporal(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeDate(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case DATE: {
                return this.internalEncodeTemporal(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    public BaseDefaultFieldItem encodeDateTime(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case DATE_AND_TIME: {
                return this.internalEncodeTemporal(field, values);
            }
        }
        throw new PlcRuntimeException("Invalid encoder for type " + s7Field.getDataType().name());
    }

    private BaseDefaultFieldItem internalEncodeBoolean(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case BOOL: 
            case BYTE: 
            case WORD: 
            case DWORD: 
            case LWORD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot assign boolean values to " + s7Field.getDataType().name() + " fields.");
            }
        }
        LinkedList<Boolean> booleanValues = new LinkedList<Boolean>();
        for (Object value : values) {
            BitSet bitSet;
            if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                booleanValues.add(booleanValue);
                continue;
            }
            if (value instanceof Byte) {
                Byte byteValue = (Byte)value;
                bitSet = BitSet.valueOf(new byte[]{byteValue});
                for (int i = 0; i < 8; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Short) {
                Short shortValue = (Short)value;
                bitSet = BitSet.valueOf(new long[]{shortValue.shortValue()});
                for (int i = 0; i < 16; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                bitSet = BitSet.valueOf(new long[]{integerValue.intValue()});
                for (int i = 0; i < 32; ++i) {
                    booleanValues.add(bitSet.get(i));
                }
                continue;
            }
            if (value instanceof Long) {
                long longValue = (Long)value;
                BitSet bitSet2 = BitSet.valueOf(new long[]{longValue});
                for (int i = 0; i < 64; ++i) {
                    booleanValues.add(bitSet2.get(i));
                }
                continue;
            }
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " is not assignable to " + s7Field.getDataType().name() + " fields.");
        }
        return new DefaultBooleanFieldItem(booleanValues.toArray(new Boolean[0]));
    }

    private BaseDefaultFieldItem internalEncodeInteger(PlcField field, Object[] values) {
        Number[] castedValues;
        Class valueType;
        Class<DefaultByteFieldItem> fieldType;
        BigInteger maxValue;
        BigInteger minValue;
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case BYTE: {
                minValue = BigInteger.valueOf(-128L);
                maxValue = BigInteger.valueOf(127L);
                fieldType = DefaultByteFieldItem.class;
                valueType = Byte[].class;
                castedValues = new Byte[values.length];
                break;
            }
            case WORD: {
                minValue = BigInteger.valueOf(-32768L);
                maxValue = BigInteger.valueOf(32767L);
                fieldType = DefaultShortFieldItem.class;
                valueType = Short[].class;
                castedValues = new Short[values.length];
                break;
            }
            case DWORD: {
                minValue = BigInteger.valueOf(Integer.MIN_VALUE);
                maxValue = BigInteger.valueOf(Integer.MAX_VALUE);
                fieldType = DefaultIntegerFieldItem.class;
                valueType = Integer[].class;
                castedValues = new Integer[values.length];
                break;
            }
            case LWORD: {
                minValue = BigInteger.valueOf(Long.MIN_VALUE);
                maxValue = BigInteger.valueOf(Long.MAX_VALUE);
                fieldType = DefaultLongFieldItem.class;
                valueType = Long[].class;
                castedValues = new Long[values.length];
                break;
            }
            case SINT: {
                minValue = BigInteger.valueOf(-128L);
                maxValue = BigInteger.valueOf(127L);
                fieldType = DefaultByteFieldItem.class;
                valueType = Byte[].class;
                castedValues = new Byte[values.length];
                break;
            }
            case USINT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(254L);
                fieldType = DefaultShortFieldItem.class;
                valueType = Short[].class;
                castedValues = new Short[values.length];
                break;
            }
            case INT: {
                minValue = BigInteger.valueOf(-32768L);
                maxValue = BigInteger.valueOf(32767L);
                fieldType = DefaultShortFieldItem.class;
                valueType = Short[].class;
                castedValues = new Short[values.length];
                break;
            }
            case UINT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(65534L);
                fieldType = DefaultIntegerFieldItem.class;
                valueType = Integer[].class;
                castedValues = new Integer[values.length];
                break;
            }
            case DINT: {
                minValue = BigInteger.valueOf(Integer.MIN_VALUE);
                maxValue = BigInteger.valueOf(Integer.MAX_VALUE);
                fieldType = DefaultIntegerFieldItem.class;
                valueType = Integer[].class;
                castedValues = new Integer[values.length];
                break;
            }
            case UDINT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(0xFFFFFFFEL);
                fieldType = DefaultLongFieldItem.class;
                valueType = Long[].class;
                castedValues = new Long[values.length];
                break;
            }
            case LINT: {
                minValue = BigInteger.valueOf(Long.MIN_VALUE);
                maxValue = BigInteger.valueOf(Long.MAX_VALUE);
                fieldType = DefaultLongFieldItem.class;
                valueType = Long[].class;
                castedValues = new Long[values.length];
                break;
            }
            case ULINT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(2L));
                fieldType = DefaultBigIntegerFieldItem.class;
                valueType = BigInteger[].class;
                castedValues = new BigInteger[values.length];
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot assign integer values to " + s7Field.getDataType().name() + " fields.");
            }
        }
        for (int i = 0; i < values.length; ++i) {
            BigInteger value;
            if (values[i] instanceof BigInteger) {
                value = (BigInteger)values[i];
            } else if (values[i] instanceof Byte || values[i] instanceof Short || values[i] instanceof Integer || values[i] instanceof Long) {
                value = BigInteger.valueOf(((Number)values[i]).longValue());
            } else {
                throw new IllegalArgumentException("Value of type " + values[i].getClass().getName() + " is not assignable to " + s7Field.getDataType().name() + " fields.");
            }
            if (minValue.compareTo(value) > 0) {
                throw new IllegalArgumentException("Value of " + value.toString() + " exceeds allowed minimum for type " + s7Field.getDataType().name() + " (min " + minValue.toString() + ")");
            }
            if (maxValue.compareTo(value) < 0) {
                throw new IllegalArgumentException("Value of " + value.toString() + " exceeds allowed maximum for type " + s7Field.getDataType().name() + " (max " + maxValue.toString() + ")");
            }
            castedValues[i] = valueType == Byte[].class ? (Number)value.byteValue() : (Number)(valueType == Short[].class ? (Number)value.shortValue() : (Number)(valueType == Integer[].class ? (Number)value.intValue() : (Number)(valueType == Long[].class ? Long.valueOf(value.longValue()) : value)));
        }
        try {
            return (BaseDefaultFieldItem)fieldType.getDeclaredConstructor(valueType).newInstance(new Object[]{castedValues});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PlcRuntimeException("Error initializing field class " + fieldType.getSimpleName(), (Throwable)e);
        }
    }

    private BaseDefaultFieldItem internalEncodeFloatingPoint(PlcField field, Object[] values) {
        Number[] castedValues;
        Class valueType;
        Class<DefaultFloatFieldItem> fieldType;
        Double maxValue;
        Double minValue;
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case REAL: {
                minValue = -3.4028234663852886E38;
                maxValue = 3.4028234663852886E38;
                fieldType = DefaultFloatFieldItem.class;
                valueType = Float[].class;
                castedValues = new Float[values.length];
                break;
            }
            case LREAL: {
                minValue = -1.7976931348623157E308;
                maxValue = Double.MAX_VALUE;
                fieldType = DefaultDoubleFieldItem.class;
                valueType = Double[].class;
                castedValues = new Double[values.length];
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot assign floating point values to " + s7Field.getDataType().name() + " fields.");
            }
        }
        for (int i = 0; i < values.length; ++i) {
            Double value;
            if (values[i] instanceof Float) {
                value = ((Float)values[i]).doubleValue();
            } else if (values[i] instanceof Double) {
                value = (Double)values[i];
            } else {
                throw new IllegalArgumentException("Value of type " + values[i].getClass().getName() + " is not assignable to " + s7Field.getDataType().name() + " fields.");
            }
            if (value < minValue) {
                throw new IllegalArgumentException("Value of " + value + " exceeds allowed minimum for type " + s7Field.getDataType().name() + " (min " + minValue.toString() + ")");
            }
            if (value > maxValue) {
                throw new IllegalArgumentException("Value of " + value + " exceeds allowed maximum for type " + s7Field.getDataType().name() + " (max " + maxValue.toString() + ")");
            }
            castedValues[i] = valueType == Float[].class ? (Number)Float.valueOf(value.floatValue()) : (Number)value;
        }
        try {
            return (BaseDefaultFieldItem)fieldType.getDeclaredConstructor(valueType).newInstance(new Object[]{castedValues});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PlcRuntimeException("Error initializing field class " + fieldType.getSimpleName(), (Throwable)e);
        }
    }

    private BaseDefaultFieldItem internalEncodeString(PlcField field, Object[] values) {
        boolean encoding16Bit;
        int maxLength;
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case CHAR: {
                maxLength = 1;
                encoding16Bit = false;
                break;
            }
            case WCHAR: {
                maxLength = 1;
                encoding16Bit = true;
                break;
            }
            case STRING: {
                maxLength = 254;
                encoding16Bit = false;
                break;
            }
            case WSTRING: {
                maxLength = 254;
                encoding16Bit = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot assign string values to " + s7Field.getDataType().name() + " fields.");
            }
        }
        LinkedList<String> stringValues = new LinkedList<String>();
        for (Object value : values) {
            byte[] stringBytes;
            if (value instanceof String) {
                String stringValue = (String)value;
                if (stringValue.length() > maxLength) {
                    throw new IllegalArgumentException("String length " + stringValue.length() + " exceeds allowed maximum for type " + s7Field.getDataType().name() + " (max " + maxLength + ")");
                }
                stringValues.add(stringValue);
                continue;
            }
            if (value instanceof Byte) {
                Byte byteValue = (Byte)value;
                stringBytes = new byte[]{byteValue};
                if (encoding16Bit) {
                    stringValues.add(new String(stringBytes, StandardCharsets.UTF_16));
                    continue;
                }
                stringValues.add(new String(stringBytes, StandardCharsets.UTF_8));
                continue;
            }
            if (value instanceof Short) {
                Short shortValue = (Short)value;
                stringBytes = new byte[]{(byte)(shortValue >> 8), (byte)(shortValue & 0xFF)};
                if (encoding16Bit) {
                    stringValues.add(new String(stringBytes, StandardCharsets.UTF_16));
                    continue;
                }
                stringValues.add(new String(stringBytes, StandardCharsets.UTF_8));
                continue;
            }
            if (value instanceof Integer) {
                Integer integerValue = (Integer)value;
                stringBytes = new byte[]{(byte)(integerValue >> 24 & 0xFF), (byte)(integerValue >> 16 & 0xFF), (byte)(integerValue >> 8 & 0xFF), (byte)(integerValue & 0xFF)};
                if (encoding16Bit) {
                    stringValues.add(new String(stringBytes, StandardCharsets.UTF_16));
                    continue;
                }
                stringValues.add(new String(stringBytes, StandardCharsets.UTF_8));
                continue;
            }
            if (value instanceof Long) {
                Long longValue = (Long)value;
                stringBytes = new byte[]{(byte)(longValue >> 56 & 0xFFL), (byte)(longValue >> 48 & 0xFFL), (byte)(longValue >> 40 & 0xFFL), (byte)(longValue >> 32 & 0xFFL), (byte)(longValue >> 24 & 0xFFL), (byte)(longValue >> 16 & 0xFFL), (byte)(longValue >> 8 & 0xFFL), (byte)(longValue & 0xFFL)};
                if (encoding16Bit) {
                    stringValues.add(new String(stringBytes, StandardCharsets.UTF_16));
                    continue;
                }
                stringValues.add(new String(stringBytes, StandardCharsets.UTF_8));
                continue;
            }
            throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " is not assignable to " + s7Field.getDataType().name() + " fields.");
        }
        return new DefaultStringFieldItem(stringValues.toArray(new String[0]));
    }

    private BaseDefaultFieldItem internalEncodeTemporal(PlcField field, Object[] values) {
        S7Field s7Field = (S7Field)field;
        switch (s7Field.getDataType()) {
            case TIME: 
            case DATE: 
            case DATE_AND_TIME: {
                return new DefaultLocalDateTimeFieldItem(new LocalDateTime[0]);
            }
        }
        throw new IllegalArgumentException("Cannot assign temporal values to " + s7Field.getDataType().name() + " fields.");
    }
}

