/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.types;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportSize;
import org.apache.plc4x.java.s7.types.S7ControllerType;

public enum TransportSize {
    BOOL(1, "X", 1, null, DataTransportSize.BIT, S7ControllerType.ANY),
    BYTE(2, "B", 1, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    WORD(4, "W", 2, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    DWORD(6, "D", 4, WORD, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    LWORD(0, "X", 8, null, null, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    INT(5, "W", 2, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    UINT(5, "W", 2, INT, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    SINT(2, "B", 1, INT, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    USINT(2, "B", 1, INT, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    DINT(7, "D", 4, INT, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    UDINT(7, "D", 4, INT, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    LINT(0, "X", 8, INT, null, S7ControllerType.S7_1500),
    ULINT(0, "X", 16, INT, null, S7ControllerType.S7_1500),
    REAL(8, "D", 4, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    LREAL(0, "X", 8, REAL, null, S7ControllerType.S7_1200, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    TIME(11, "X", 4, null, null, S7ControllerType.ANY),
    LTIME(0, "X", 8, TIME, null, S7ControllerType.S7_1500),
    DATE(0, "X", 2, null, null, S7ControllerType.ANY),
    TIME_OF_DAY(10, "X", 4, null, null, S7ControllerType.ANY),
    DATE_AND_TIME(15, "X", 8, null, null, S7ControllerType.ANY),
    CHAR(3, "B", 1, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    WCHAR(19, "X", 2, null, null, S7ControllerType.S7_1200, S7ControllerType.S7_1500),
    STRING(3, "X", 1, null, DataTransportSize.BYTE_WORD_DWORD, S7ControllerType.ANY),
    WSTRING(0, "X", 1, null, null, S7ControllerType.S7_1200, S7ControllerType.S7_1500);

    private static final Map<Byte, TransportSize> map;
    private final byte typeCode;
    private final String sizeCode;
    private final int sizeInBytes;
    private final Set<S7ControllerType> supportedControllerTypes;
    private final TransportSize baseType;
    private final DataTransportSize dataTransportSize;

    private TransportSize(int typeCode, String sizeCode, int sizeInBytes, TransportSize baseType, DataTransportSize dataTransportSize, S7ControllerType ... supportedControllerTypes) {
        this.typeCode = (byte)typeCode;
        this.sizeCode = sizeCode;
        this.sizeInBytes = sizeInBytes;
        this.supportedControllerTypes = new HashSet<S7ControllerType>(Arrays.asList(supportedControllerTypes));
        this.baseType = baseType;
        this.dataTransportSize = dataTransportSize;
    }

    public byte getTypeCode() {
        return this.typeCode;
    }

    public String getSizeCode() {
        return this.sizeCode;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public boolean isBaseType() {
        return this.baseType == null;
    }

    TransportSize getBaseType() {
        if (this.baseType == null) {
            return this;
        }
        return this.baseType;
    }

    TransportSize getSubType(String sizeCode) {
        for (TransportSize value : TransportSize.values()) {
            if (value.baseType != this || value.sizeCode == null || !value.sizeCode.equals(sizeCode)) continue;
            return value;
        }
        return null;
    }

    public DataTransportSize getDataTransportSize() {
        return this.dataTransportSize;
    }

    boolean isControllerTypeSupported(S7ControllerType controllerType) {
        return this.supportedControllerTypes.contains((Object)controllerType);
    }

    public static TransportSize valueOf(byte code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Byte, TransportSize>();
        for (TransportSize dataType : TransportSize.values()) {
            map.put(dataType.typeCode, dataType);
        }
    }
}

