/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.types;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ParameterType {
    CPU_SERVICES(0),
    READ_VAR(4),
    WRITE_VAR(5),
    REQUEST_DOWNLOAD(26),
    DOWNLOAD_BLOCK(27),
    DOWNLOAD_ENDED(28),
    START_UPLOAD(29),
    UPLOAD(30),
    END_UPLOAD(31),
    PI_SERVICE(40),
    PLC_STOP(41),
    SETUP_COMMUNICATION(-16);

    private static final Logger logger;
    private static final Map<Byte, ParameterType> map;
    private final byte code;

    private ParameterType(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static ParameterType valueOf(byte code) {
        if (!map.containsKey(code)) {
            logger.error("ParameterType for code {} not found", (Object)code);
        }
        return map.get(code);
    }

    static {
        logger = LoggerFactory.getLogger(ParameterType.class);
        map = new HashMap<Byte, ParameterType>();
        for (ParameterType parameterType : ParameterType.values()) {
            map.put(parameterType.code, parameterType);
        }
    }
}

