/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.types;

import java.util.HashMap;
import java.util.Map;

public enum MemoryArea {
    COUNTERS("C", 28),
    TIMERS("T", 29),
    DIRECT_PERIPHERAL_ACCESS("D", -128),
    INPUTS("I", -127),
    OUTPUTS("Q", -126),
    FLAGS_MARKERS("M", -125),
    DATA_BLOCKS("DB", -124),
    INSTANCE_DATA_BLOCKS("DBI", -123),
    LOCAL_DATA("LD", -122);

    private static final Map<Byte, MemoryArea> map;
    private final String shortName;
    private final byte code;

    private MemoryArea(String shortName, byte code) {
        this.shortName = shortName;
        this.code = code;
    }

    public String getShortName() {
        return this.shortName;
    }

    public byte getCode() {
        return this.code;
    }

    public static MemoryArea valueOfShortName(String shortName) {
        for (MemoryArea value : MemoryArea.values()) {
            if (!value.getShortName().equals(shortName)) continue;
            return value;
        }
        return null;
    }

    public static MemoryArea valueOf(byte code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Byte, MemoryArea>();
        for (MemoryArea memoryArea : MemoryArea.values()) {
            map.put(memoryArea.code, memoryArea);
        }
    }
}

