/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.types;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DataTransportErrorCode {
    RESERVED(0),
    OK(-1),
    ACCESS_DENIED(3),
    INVALID_ADDRESS(5),
    DATA_TYPE_NOT_SUPPORTED(6),
    NOT_FOUND(10);

    private static final Logger logger;
    private static final Map<Byte, DataTransportErrorCode> map;
    private byte code;

    private DataTransportErrorCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static DataTransportErrorCode valueOf(byte code) {
        if (!map.containsKey(code)) {
            logger.error("No DataTransportErrorCode for code {}", (Object)code);
        }
        return map.get(code);
    }

    static {
        logger = LoggerFactory.getLogger(DataTransportErrorCode.class);
        map = new HashMap<Byte, DataTransportErrorCode>();
        for (DataTransportErrorCode dataTransportErrorCode : DataTransportErrorCode.values()) {
            map.put(dataTransportErrorCode.code, dataTransportErrorCode);
        }
    }
}

