/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty.model.messages;

import java.util.List;
import java.util.Optional;
import org.apache.plc4x.java.base.messages.PlcProtocolMessage;
import org.apache.plc4x.java.base.messages.PlcRawMessage;
import org.apache.plc4x.java.s7.netty.model.params.S7Parameter;
import org.apache.plc4x.java.s7.netty.model.payloads.S7Payload;
import org.apache.plc4x.java.s7.netty.model.types.MessageType;

public abstract class S7Message
extends PlcRawMessage {
    private final MessageType messageType;
    private final short tpduReference;
    private final List<S7Parameter> parameters;
    private final List<S7Payload> payloads;

    protected S7Message(MessageType messageType, short tpduReference, List<S7Parameter> parameters, List<S7Payload> payloads) {
        this(messageType, tpduReference, parameters, payloads, null);
    }

    protected S7Message(MessageType messageType, short tpduReference, List<S7Parameter> parameters, List<S7Payload> payloads, PlcProtocolMessage parent) {
        super(null, parent);
        this.messageType = messageType;
        this.tpduReference = tpduReference;
        this.parameters = parameters;
        this.payloads = payloads;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public short getTpduReference() {
        return this.tpduReference;
    }

    public List<S7Parameter> getParameters() {
        return this.parameters;
    }

    public <T> Optional<T> getParameter(Class<T> parameterType) {
        if (this.parameters != null) {
            for (S7Parameter s7Parameter : this.parameters) {
                if (s7Parameter.getClass() != parameterType) continue;
                return Optional.of(parameterType.cast(s7Parameter));
            }
        }
        return Optional.empty();
    }

    public List<S7Payload> getPayloads() {
        return this.payloads;
    }

    public <T> Optional<T> getPayload(Class<T> payloadType) {
        if (this.payloads != null) {
            for (S7Payload s7Payload : this.payloads) {
                if (s7Payload.getClass() != payloadType) continue;
                return Optional.of(payloadType.cast(s7Payload));
            }
        }
        return Optional.empty();
    }
}

