/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.plc4x.java.api.exceptions.PlcException;
import org.apache.plc4x.java.api.exceptions.PlcIoException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcProtocolPayloadTooBigException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.PlcMessageToMessageCodec;
import org.apache.plc4x.java.base.events.ConnectedEvent;
import org.apache.plc4x.java.base.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcRequest;
import org.apache.plc4x.java.base.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.base.messages.PlcProtocolMessage;
import org.apache.plc4x.java.base.messages.PlcRequestContainer;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBigIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultBooleanFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultByteFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultDoubleFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultFloatFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultIntegerFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultLongFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultShortFieldItem;
import org.apache.plc4x.java.base.messages.items.DefaultStringFieldItem;
import org.apache.plc4x.java.s7.model.S7Field;
import org.apache.plc4x.java.s7.netty.events.S7ConnectedEvent;
import org.apache.plc4x.java.s7.netty.model.messages.S7Message;
import org.apache.plc4x.java.s7.netty.model.messages.S7RequestMessage;
import org.apache.plc4x.java.s7.netty.model.messages.S7ResponseMessage;
import org.apache.plc4x.java.s7.netty.model.params.VarParameter;
import org.apache.plc4x.java.s7.netty.model.params.items.S7AnyVarParameterItem;
import org.apache.plc4x.java.s7.netty.model.params.items.VarParameterItem;
import org.apache.plc4x.java.s7.netty.model.payloads.VarPayload;
import org.apache.plc4x.java.s7.netty.model.payloads.items.VarPayloadItem;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportErrorCode;
import org.apache.plc4x.java.s7.netty.model.types.DataTransportSize;
import org.apache.plc4x.java.s7.netty.model.types.MessageType;
import org.apache.plc4x.java.s7.netty.model.types.ParameterType;
import org.apache.plc4x.java.s7.netty.model.types.SpecificationType;
import org.apache.plc4x.java.s7.netty.model.types.TransportSize;

public class Plc4XS7Protocol
extends PlcMessageToMessageCodec<S7Message, PlcRequestContainer> {
    private static final AtomicInteger tpduGenerator = new AtomicInteger(10);
    private Map<Short, PlcRequestContainer> requests = new HashMap<Short, PlcRequestContainer>();

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof S7ConnectedEvent) {
            ctx.channel().pipeline().fireUserEventTriggered((Object)new ConnectedEvent());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof PlcProtocolPayloadTooBigException) {
            S7RequestMessage request;
            PlcProtocolPayloadTooBigException pptbe = (PlcProtocolPayloadTooBigException)cause;
            if (pptbe.getPayload() instanceof S7RequestMessage && (request = (S7RequestMessage)((Object)pptbe.getPayload())).getParent() instanceof PlcRequestContainer) {
                PlcRequestContainer requestContainer = (PlcRequestContainer)request.getParent();
                this.requests.remove(request.getTpduReference());
                requestContainer.getResponseFuture().completeExceptionally(cause);
            }
        } else if (cause instanceof IOException && (cause.getMessage().contains("Connection reset by peer") || cause.getMessage().contains("Operation timed out"))) {
            String reason;
            String string = reason = cause.getMessage().contains("Connection reset by peer") ? "Connection terminated unexpectedly" : "Remote host not responding";
            if (!this.requests.isEmpty()) {
                for (PlcRequestContainer requestContainer : this.requests.values()) {
                    requestContainer.getResponseFuture().completeExceptionally((Throwable)new PlcIoException(reason));
                }
                this.requests.clear();
            }
        } else {
            super.exceptionCaught(ctx, cause);
        }
    }

    protected void encode(ChannelHandlerContext ctx, PlcRequestContainer msg, List<Object> out) throws PlcException {
        InternalPlcRequest request = msg.getRequest();
        if (request instanceof PlcReadRequest) {
            this.encodeReadRequest(msg, out);
        } else if (request instanceof PlcWriteRequest) {
            this.encodeWriteRequest(msg, out);
        }
    }

    private void encodeReadRequest(PlcRequestContainer msg, List<Object> out) throws PlcException {
        LinkedList<VarParameterItem> parameterItems = new LinkedList<VarParameterItem>();
        PlcReadRequest readRequest = (PlcReadRequest)msg.getRequest();
        for (String fieldName : readRequest.getFieldNames()) {
            PlcField field = readRequest.getField(fieldName);
            if (!(field instanceof S7Field)) {
                throw new PlcProtocolException("The field should have been of type S7Field");
            }
            S7Field s7Field = (S7Field)field;
            S7AnyVarParameterItem varParameterItem = new S7AnyVarParameterItem(SpecificationType.VARIABLE_SPECIFICATION, s7Field.getMemoryArea(), s7Field.getDataType(), s7Field.getNumElements(), s7Field.getBlockNumber(), s7Field.getByteOffset(), (byte)s7Field.getBitOffset());
            parameterItems.add(varParameterItem);
        }
        VarParameter readVarParameter = new VarParameter(ParameterType.READ_VAR, parameterItems);
        S7RequestMessage s7ReadRequest = new S7RequestMessage(MessageType.JOB, (short)tpduGenerator.getAndIncrement(), Collections.singletonList(readVarParameter), Collections.emptyList(), (PlcProtocolMessage)msg);
        this.requests.put(s7ReadRequest.getTpduReference(), msg);
        out.add((Object)s7ReadRequest);
    }

    private void encodeWriteRequest(PlcRequestContainer msg, List<Object> out) throws PlcException {
        LinkedList<VarParameterItem> parameterItems = new LinkedList<VarParameterItem>();
        LinkedList<VarPayloadItem> payloadItems = new LinkedList<VarPayloadItem>();
        PlcWriteRequest writeRequest = (PlcWriteRequest)msg.getRequest();
        for (String fieldName : writeRequest.getFieldNames()) {
            byte[] byteData;
            PlcField field = writeRequest.getField(fieldName);
            if (!(field instanceof S7Field)) {
                throw new PlcException("The field should have been of type S7Field");
            }
            S7Field s7Field = (S7Field)field;
            if (!(writeRequest instanceof DefaultPlcWriteRequest)) {
                throw new PlcException("The writeRequest should have been of type DefaultPlcWriteRequest");
            }
            BaseDefaultFieldItem fieldItem = ((DefaultPlcWriteRequest)writeRequest).getFieldItem(fieldName);
            if (s7Field.getDataType() != TransportSize.STRING && writeRequest.getNumberOfValues(fieldName) != s7Field.getNumElements()) {
                throw new PlcException("The number of values provided doesn't match the number specified by the field.");
            }
            S7AnyVarParameterItem varParameterItem = new S7AnyVarParameterItem(SpecificationType.VARIABLE_SPECIFICATION, s7Field.getMemoryArea(), s7Field.getDataType(), s7Field.getNumElements(), s7Field.getBlockNumber(), s7Field.getByteOffset(), (byte)s7Field.getBitOffset());
            parameterItems.add(varParameterItem);
            DataTransportSize dataTransportSize = s7Field.getDataType().getDataTransportSize();
            switch (s7Field.getDataType()) {
                case BOOL: {
                    byteData = this.encodeWriteRequestBitField(fieldItem);
                    break;
                }
                case BYTE: 
                case SINT: 
                case CHAR: {
                    byteData = this.encodeWriteRequestByteField(fieldItem, true);
                    break;
                }
                case WORD: 
                case INT: 
                case WCHAR: {
                    byteData = this.encodeWriteRequestShortField(fieldItem, true);
                    break;
                }
                case DWORD: 
                case DINT: {
                    byteData = this.encodeWriteRequestIntegerField(fieldItem, true);
                    break;
                }
                case LWORD: 
                case LINT: {
                    byteData = this.encodeWriteRequestLongField(fieldItem, true);
                    break;
                }
                case USINT: {
                    byteData = this.encodeWriteRequestByteField(fieldItem, false);
                    break;
                }
                case UINT: {
                    byteData = this.encodeWriteRequestShortField(fieldItem, false);
                    break;
                }
                case UDINT: {
                    byteData = this.encodeWriteRequestIntegerField(fieldItem, false);
                    break;
                }
                case ULINT: {
                    byteData = this.encodeWriteRequestLongField(fieldItem, false);
                    break;
                }
                case REAL: {
                    byteData = this.encodeWriteRequestFloatField(fieldItem);
                    break;
                }
                case LREAL: {
                    byteData = this.encodeWriteRequestDoubleField(fieldItem);
                    break;
                }
                case STRING: {
                    byteData = this.encodeWriteRequestStringField(fieldItem, false);
                    break;
                }
                case WSTRING: {
                    byteData = this.encodeWriteRequestStringField(fieldItem, true);
                    break;
                }
                default: {
                    throw new PlcProtocolException("Unsupported type " + (Object)((Object)s7Field.getDataType()));
                }
            }
            VarPayloadItem varPayloadItem = new VarPayloadItem(DataTransportErrorCode.RESERVED, dataTransportSize, byteData);
            payloadItems.add(varPayloadItem);
        }
        VarParameter writeVarParameter = new VarParameter(ParameterType.WRITE_VAR, parameterItems);
        VarPayload writeVarPayload = new VarPayload(ParameterType.WRITE_VAR, payloadItems);
        S7RequestMessage s7WriteRequest = new S7RequestMessage(MessageType.JOB, (short)tpduGenerator.getAndIncrement(), Collections.singletonList(writeVarParameter), Collections.singletonList(writeVarPayload), (PlcProtocolMessage)msg);
        this.requests.put(s7WriteRequest.getTpduReference(), msg);
        out.add((Object)s7WriteRequest);
    }

    byte[] encodeWriteRequestBitField(BaseDefaultFieldItem fieldItem) {
        int numBytes = fieldItem.getNumberOfValues() >> 0;
        byte[] byteData = new byte[numBytes];
        BitSet bitSet = new BitSet();
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            bitSet.set(i, fieldItem.getBoolean(i));
        }
        byte[] src = bitSet.toByteArray();
        System.arraycopy(src, 0, byteData, 0, Math.min(src.length, numBytes));
        return byteData;
    }

    byte[] encodeWriteRequestByteField(BaseDefaultFieldItem fieldItem, boolean signed) {
        int numBytes = fieldItem.getNumberOfValues();
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            if (signed) {
                buffer.put(fieldItem.getByte(i));
                continue;
            }
            buffer.put((byte)fieldItem.getShort(i).shortValue());
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestShortField(BaseDefaultFieldItem fieldItem, boolean signed) {
        int numBytes = fieldItem.getNumberOfValues() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            if (signed) {
                buffer.putShort(fieldItem.getShort(i));
                continue;
            }
            buffer.putShort((short)fieldItem.getInteger(i).intValue());
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestIntegerField(BaseDefaultFieldItem fieldItem, boolean signed) {
        int numBytes = fieldItem.getNumberOfValues() * 4;
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            if (signed) {
                buffer.putInt(fieldItem.getInteger(i));
                continue;
            }
            buffer.putInt((int)fieldItem.getLong(i).longValue());
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestLongField(BaseDefaultFieldItem fieldItem, boolean signed) {
        int numBytes = fieldItem.getNumberOfValues() * 8;
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            if (!signed) continue;
            buffer.putLong(fieldItem.getLong(i));
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestFloatField(BaseDefaultFieldItem fieldItem) {
        int numBytes = fieldItem.getNumberOfValues() * 4;
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            buffer.putFloat(fieldItem.getFloat(i).floatValue());
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestDoubleField(BaseDefaultFieldItem fieldItem) {
        int numBytes = fieldItem.getNumberOfValues() * 8;
        ByteBuffer buffer = ByteBuffer.allocate(numBytes);
        for (int i = 0; i < fieldItem.getNumberOfValues(); ++i) {
            buffer.putDouble(fieldItem.getDouble(i));
        }
        return buffer.array();
    }

    byte[] encodeWriteRequestStringField(BaseDefaultFieldItem fieldItem, boolean isUtf16) {
        return new byte[0];
    }

    protected void decode(ChannelHandlerContext ctx, S7Message msg, List<Object> out) throws PlcException {
        if (!(msg instanceof S7ResponseMessage)) {
            return;
        }
        S7ResponseMessage responseMessage = (S7ResponseMessage)msg;
        short tpduReference = responseMessage.getTpduReference();
        if (this.requests.containsKey(tpduReference)) {
            PlcRequestContainer requestContainer = this.requests.remove(tpduReference);
            InternalPlcRequest request = requestContainer.getRequest();
            PlcResponse response = null;
            if (request instanceof PlcReadRequest) {
                response = this.decodeReadResponse(responseMessage, requestContainer);
            } else if (request instanceof PlcWriteRequest) {
                response = this.decodeWriteResponse(responseMessage, requestContainer);
            }
            if (response != null) {
                requestContainer.getResponseFuture().complete(response);
            }
        }
    }

    private PlcResponse decodeReadResponse(S7ResponseMessage responseMessage, PlcRequestContainer requestContainer) throws PlcProtocolException {
        InternalPlcReadRequest plcReadRequest = (InternalPlcReadRequest)requestContainer.getRequest();
        VarPayload payload = responseMessage.getPayload(VarPayload.class).orElseThrow(() -> new PlcProtocolException("No VarPayload supplied"));
        if (plcReadRequest.getNumberOfFields() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        HashMap<String, ImmutablePair> values = new HashMap<String, ImmutablePair>();
        List<VarPayloadItem> payloadItems = payload.getItems();
        int index = 0;
        for (String fieldName : plcReadRequest.getFieldNames()) {
            S7Field field = (S7Field)plcReadRequest.getField(fieldName);
            VarPayloadItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            BaseDefaultFieldItem fieldItem = null;
            ByteBuf data = Unpooled.wrappedBuffer((byte[])payloadItem.getData());
            if (responseCode == PlcResponseCode.OK) {
                switch (field.getDataType()) {
                    case BOOL: {
                        fieldItem = this.decodeReadResponseBitField(field, data);
                        break;
                    }
                    case BYTE: {
                        fieldItem = this.decodeReadResponseByteBitStringField(field, data);
                        break;
                    }
                    case WORD: {
                        fieldItem = this.decodeReadResponseShortBitStringField(field, data);
                        break;
                    }
                    case DWORD: {
                        fieldItem = this.decodeReadResponseIntegerBitStringField(field, data);
                        break;
                    }
                    case LWORD: {
                        fieldItem = this.decodeReadResponseLongBitStringField(field, data);
                        break;
                    }
                    case SINT: {
                        fieldItem = this.decodeReadResponseSignedByteField(field, data);
                        break;
                    }
                    case USINT: {
                        fieldItem = this.decodeReadResponseUnsignedByteField(field, data);
                        break;
                    }
                    case INT: {
                        fieldItem = this.decodeReadResponseSignedShortField(field, data);
                        break;
                    }
                    case UINT: {
                        fieldItem = this.decodeReadResponseUnsignedShortField(field, data);
                        break;
                    }
                    case DINT: {
                        fieldItem = this.decodeReadResponseSignedIntegerField(field, data);
                        break;
                    }
                    case UDINT: {
                        fieldItem = this.decodeReadResponseUnsignedIntegerField(field, data);
                        break;
                    }
                    case LINT: {
                        fieldItem = this.decodeReadResponseSignedLongField(field, data);
                        break;
                    }
                    case ULINT: {
                        fieldItem = this.decodeReadResponseUnsignedLongField(field, data);
                        break;
                    }
                    case REAL: {
                        fieldItem = this.decodeReadResponseFloatField(field, data);
                        break;
                    }
                    case LREAL: {
                        fieldItem = this.decodeReadResponseDoubleField(field, data);
                        break;
                    }
                    case CHAR: {
                        fieldItem = this.decodeReadResponseFixedLengthStringField(1, false, data);
                        break;
                    }
                    case WCHAR: {
                        fieldItem = this.decodeReadResponseFixedLengthStringField(1, true, data);
                        break;
                    }
                    case STRING: {
                        fieldItem = this.decodeReadResponseVarLengthStringField(false, data);
                        break;
                    }
                    case WSTRING: {
                        fieldItem = this.decodeReadResponseVarLengthStringField(true, data);
                        break;
                    }
                    default: {
                        throw new PlcProtocolException("Unsupported type " + (Object)((Object)field.getDataType()));
                    }
                }
            }
            ImmutablePair result = new ImmutablePair((Object)responseCode, fieldItem);
            values.put(fieldName, result);
            ++index;
        }
        return new DefaultPlcReadResponse(plcReadRequest, values);
    }

    BaseDefaultFieldItem decodeReadResponseBitField(S7Field field, ByteBuf data) {
        Boolean[] booleans = Plc4XS7Protocol.readAllValues(Boolean.class, field, i -> data.readByte() != 0);
        return new DefaultBooleanFieldItem(booleans);
    }

    BaseDefaultFieldItem decodeReadResponseByteBitStringField(S7Field field, ByteBuf data) {
        byte[] bytes = new byte[field.getNumElements()];
        data.readBytes(bytes);
        return this.decodeBitStringField(bytes);
    }

    BaseDefaultFieldItem decodeReadResponseShortBitStringField(S7Field field, ByteBuf data) {
        byte[] bytes = new byte[field.getNumElements() * 2];
        data.readBytes(bytes);
        return this.decodeBitStringField(bytes);
    }

    BaseDefaultFieldItem decodeReadResponseIntegerBitStringField(S7Field field, ByteBuf data) {
        byte[] bytes = new byte[field.getNumElements() * 4];
        data.readBytes(bytes);
        return this.decodeBitStringField(bytes);
    }

    BaseDefaultFieldItem decodeReadResponseLongBitStringField(S7Field field, ByteBuf data) {
        byte[] bytes = new byte[field.getNumElements() * 8];
        data.readBytes(bytes);
        return this.decodeBitStringField(bytes);
    }

    BaseDefaultFieldItem decodeBitStringField(byte[] bytes) {
        BitSet bitSet = BitSet.valueOf(bytes);
        Boolean[] booleanValues = new Boolean[8 * bytes.length];
        int k = 0;
        for (int i = bytes.length - 1; i >= 0; --i) {
            for (int j = 0; j < 8; ++j) {
                booleanValues[k++] = bitSet.get(8 * i + j);
            }
        }
        return new DefaultBooleanFieldItem(booleanValues);
    }

    BaseDefaultFieldItem decodeReadResponseSignedByteField(S7Field field, ByteBuf data) {
        Byte[] bytes = Plc4XS7Protocol.readAllValues(Byte.class, field, i -> data.readByte());
        return new DefaultByteFieldItem(bytes);
    }

    BaseDefaultFieldItem decodeReadResponseUnsignedByteField(S7Field field, ByteBuf data) {
        Short[] shorts = Plc4XS7Protocol.readAllValues(Short.class, field, i -> data.readUnsignedByte());
        return new DefaultShortFieldItem(shorts);
    }

    BaseDefaultFieldItem decodeReadResponseSignedShortField(S7Field field, ByteBuf data) {
        Short[] shorts = Plc4XS7Protocol.readAllValues(Short.class, field, i -> data.readShort());
        return new DefaultShortFieldItem(shorts);
    }

    BaseDefaultFieldItem decodeReadResponseUnsignedShortField(S7Field field, ByteBuf data) {
        Integer[] ints = Plc4XS7Protocol.readAllValues(Integer.class, field, i -> data.readUnsignedShort());
        return new DefaultIntegerFieldItem(ints);
    }

    BaseDefaultFieldItem decodeReadResponseSignedIntegerField(S7Field field, ByteBuf data) {
        Integer[] ints = Plc4XS7Protocol.readAllValues(Integer.class, field, i -> data.readInt());
        return new DefaultIntegerFieldItem(ints);
    }

    BaseDefaultFieldItem decodeReadResponseUnsignedIntegerField(S7Field field, ByteBuf data) {
        Long[] longs = Plc4XS7Protocol.readAllValues(Long.class, field, i -> data.readUnsignedInt());
        return new DefaultLongFieldItem(longs);
    }

    BaseDefaultFieldItem decodeReadResponseSignedLongField(S7Field field, ByteBuf data) {
        Long[] longs = Plc4XS7Protocol.readAllValues(Long.class, field, i -> data.readLong());
        return new DefaultLongFieldItem(longs);
    }

    BaseDefaultFieldItem decodeReadResponseUnsignedLongField(S7Field field, ByteBuf data) {
        BigInteger[] bigIntegers = Plc4XS7Protocol.readAllValues(BigInteger.class, field, i -> Plc4XS7Protocol.readUnsigned64BitInteger(data));
        return new DefaultBigIntegerFieldItem(bigIntegers);
    }

    BaseDefaultFieldItem decodeReadResponseFloatField(S7Field field, ByteBuf data) {
        Float[] floats = Plc4XS7Protocol.readAllValues(Float.class, field, i -> Float.valueOf(data.readFloat()));
        return new DefaultFloatFieldItem(floats);
    }

    BaseDefaultFieldItem decodeReadResponseDoubleField(S7Field field, ByteBuf data) {
        Double[] doubles = Plc4XS7Protocol.readAllValues(Double.class, field, i -> data.readDouble());
        return new DefaultDoubleFieldItem(doubles);
    }

    BaseDefaultFieldItem decodeReadResponseFixedLengthStringField(int numChars, boolean isUtf16, ByteBuf data) {
        int numBytes = isUtf16 ? numChars * 2 : numChars;
        String stringValue = data.readCharSequence(numBytes, StandardCharsets.UTF_8).toString();
        return new DefaultStringFieldItem(new String[]{stringValue});
    }

    BaseDefaultFieldItem decodeReadResponseVarLengthStringField(boolean isUtf16, ByteBuf data) {
        data.skipBytes(1);
        byte actualLength = data.readByte();
        return this.decodeReadResponseFixedLengthStringField(actualLength, isUtf16, data);
    }

    private static <T> T[] readAllValues(Class<T> clazz, S7Field field, Function<Integer, T> extract) {
        try {
            return IntStream.rangeClosed(1, field.getNumElements()).mapToObj(extract::apply).collect(Collectors.toList()).toArray((Object[])Array.newInstance(clazz, 0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new PlcRuntimeException("To few bytes in the buffer to read requested type", (Throwable)e);
        }
    }

    private PlcResponse decodeWriteResponse(S7ResponseMessage responseMessage, PlcRequestContainer requestContainer) throws PlcProtocolException {
        InternalPlcWriteRequest plcWriteRequest = (InternalPlcWriteRequest)requestContainer.getRequest();
        VarPayload payload = responseMessage.getPayload(VarPayload.class).orElseThrow(() -> new PlcProtocolException("No VarPayload supplied"));
        if (plcWriteRequest.getNumberOfFields() != payload.getItems().size()) {
            throw new PlcProtocolException("The number of requested items doesn't match the number of returned items");
        }
        HashMap<String, PlcResponseCode> values = new HashMap<String, PlcResponseCode>();
        List<VarPayloadItem> payloadItems = payload.getItems();
        int index = 0;
        for (String fieldName : plcWriteRequest.getFieldNames()) {
            VarPayloadItem payloadItem = payloadItems.get(index);
            PlcResponseCode responseCode = this.decodeResponseCode(payloadItem.getReturnCode());
            values.put(fieldName, responseCode);
            ++index;
        }
        return new DefaultPlcWriteResponse(plcWriteRequest, values);
    }

    private PlcResponseCode decodeResponseCode(DataTransportErrorCode dataTransportErrorCode) {
        if (dataTransportErrorCode == null) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        switch (dataTransportErrorCode) {
            case OK: {
                return PlcResponseCode.OK;
            }
            case NOT_FOUND: {
                return PlcResponseCode.NOT_FOUND;
            }
            case INVALID_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case DATA_TYPE_NOT_SUPPORTED: {
                return PlcResponseCode.INVALID_DATATYPE;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    private static BigInteger readUnsignedLong(ByteBuf data) {
        byte[] bytes = new byte[5];
        bytes[0] = 0;
        data.readBytes(bytes, 1, 4);
        return new BigInteger(bytes);
    }

    private static BigInteger readSigned64BitInteger(ByteBuf data) {
        byte[] bytes = new byte[8];
        data.readBytes(bytes, 0, 8);
        return new BigInteger(bytes);
    }

    private static BigInteger readUnsigned64BitInteger(ByteBuf data) {
        byte[] bytes = new byte[9];
        bytes[0] = 0;
        data.readBytes(bytes, 1, 8);
        return new BigInteger(bytes);
    }
}

