/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.isotp.protocol.model.types;

import java.util.HashMap;
import java.util.Map;

public enum ParameterCode {
    ATN_EXTENDED_CHECKSUM_32BIT(8),
    ATN_EXTENDED_CHECKSUM_16BIT(9),
    ACKNOWLEDGE_TIME(-123),
    RESIDUAL_ERROR_RATE(-122),
    PRIORITY(-121),
    TRANSIT_DELAY(-120),
    THROUGHPUT(-119),
    SEQUENCE_NUMBER(-118),
    REASSIGNMENT(-117),
    FLOW_CONTROL(-116),
    TPDU_SIZE(-64),
    CALLING_TSAP(-63),
    CALLED_TSAP(-62),
    CHECKSUM(-61),
    VERSION(-60),
    SECURITY_PARAMETERS(-59),
    ADDITIONAL_OPTION_SELECTION(-58),
    ALTERNATIVE_PROTOCOL_CLASS(-57),
    DISCONNECT_ADDITIONAL_INFORMATION(-32),
    PREFERRED_MAX_PDU_SIZE(-16),
    INACTIVITY_TIMER(-14);

    private static final Map<Byte, ParameterCode> map;
    private final byte code;

    private ParameterCode(byte code) {
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    public static ParameterCode valueOf(byte code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Byte, ParameterCode>();
        for (ParameterCode parameterCode : ParameterCode.values()) {
            map.put(parameterCode.code, parameterCode);
        }
    }
}

