/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.protocol;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.PendingWriteQueue;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.plc4x.java.api.exceptions.PlcProtocolException;
import org.apache.plc4x.java.api.exceptions.PlcTimeoutException;
import org.apache.plc4x.java.api.model.PlcField;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.base.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcUnsubscriptionRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcUnsubscriptionResponse;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.base.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.base.messages.InternalPlcFieldRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadRequest;
import org.apache.plc4x.java.base.messages.InternalPlcReadResponse;
import org.apache.plc4x.java.base.messages.InternalPlcRequest;
import org.apache.plc4x.java.base.messages.InternalPlcResponse;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcSubscriptionResponse;
import org.apache.plc4x.java.base.messages.InternalPlcUnsubscriptionRequest;
import org.apache.plc4x.java.base.messages.InternalPlcWriteRequest;
import org.apache.plc4x.java.base.messages.InternalPlcWriteResponse;
import org.apache.plc4x.java.base.messages.PlcReader;
import org.apache.plc4x.java.base.messages.PlcRequestContainer;
import org.apache.plc4x.java.base.messages.PlcSubscriber;
import org.apache.plc4x.java.base.messages.PlcWriter;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;
import org.apache.plc4x.java.base.model.InternalPlcSubscriptionHandle;
import org.apache.plc4x.java.base.model.SubscriptionPlcField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleItemToSingleRequestProtocol
extends ChannelDuplexHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(SingleItemToSingleRequestProtocol.class);
    private final Timer timer;
    private final PlcReader reader;
    private final PlcWriter writer;
    private final PlcSubscriber subscriber;
    private long defaultReceiveTimeout;
    private PendingWriteQueue queue;
    private ConcurrentMap<PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>, Timeout> scheduledTimeouts;
    private ConcurrentMap<Integer, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>> sentButUnacknowledgedSubContainer;
    private ConcurrentMap<Integer, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>> correlationToParentContainer;
    private ConcurrentMap<PlcRequestContainer<?, ?>, Set<Integer>> containerCorrelationIdMap;
    private ConcurrentMap<PlcRequestContainer<?, ?>, Queue<InternalPlcResponse>> responsesToBeDelivered;
    private AtomicInteger correlationIdGenerator;
    private AtomicLong deliveredContainers;
    private AtomicLong erroredContainers;
    private AtomicLong deliveredItems;
    private AtomicLong erroredItems;
    private SplitConfig splitConfig;

    public SingleItemToSingleRequestProtocol(PlcReader reader, PlcWriter writer, PlcSubscriber subscriber, Timer timer) {
        this(reader, writer, subscriber, timer, new SplitConfig());
    }

    public SingleItemToSingleRequestProtocol(PlcReader reader, PlcWriter writer, PlcSubscriber subscriber, Timer timer, SplitConfig splitConfig) {
        this(reader, writer, subscriber, timer, splitConfig, true);
    }

    public SingleItemToSingleRequestProtocol(PlcReader reader, PlcWriter writer, PlcSubscriber subscriber, Timer timer, SplitConfig splitConfig, boolean betterImplementationPossible) {
        this(reader, writer, subscriber, timer, TimeUnit.SECONDS.toMillis(30L), splitConfig, betterImplementationPossible);
    }

    public SingleItemToSingleRequestProtocol(PlcReader reader, PlcWriter writer, PlcSubscriber subscriber, Timer timer, long defaultReceiveTimeout, SplitConfig splitConfig, boolean betterImplementationPossible) {
        this.reader = reader;
        this.writer = writer;
        this.subscriber = subscriber;
        this.timer = timer;
        this.defaultReceiveTimeout = defaultReceiveTimeout;
        this.splitConfig = splitConfig;
        if (this.splitConfig == null) {
            this.splitConfig = new SplitConfig();
        }
        if (betterImplementationPossible) {
            String callStack = Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            LOGGER.warn("Unoptimized Usage of {} detected at:\n{}", ((Object)((Object)this)).getClass(), (Object)callStack);
            LOGGER.info("Consider implementing item splitting native to the protocol.");
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.queue = new PendingWriteQueue(ctx);
        this.scheduledTimeouts = new ConcurrentHashMap<PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>, Timeout>();
        this.sentButUnacknowledgedSubContainer = new ConcurrentHashMap<Integer, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>>();
        this.correlationToParentContainer = new ConcurrentHashMap<Integer, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse>>();
        this.containerCorrelationIdMap = new ConcurrentHashMap();
        this.responsesToBeDelivered = new ConcurrentHashMap();
        this.correlationIdGenerator = new AtomicInteger();
        this.deliveredItems = new AtomicLong();
        this.erroredItems = new AtomicLong();
        this.deliveredContainers = new AtomicLong();
        this.erroredContainers = new AtomicLong();
        super.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.queue.removeAndWriteAll();
        this.scheduledTimeouts.clear();
        this.sentButUnacknowledgedSubContainer.clear();
        this.correlationToParentContainer.clear();
        this.containerCorrelationIdMap.clear();
        this.responsesToBeDelivered.clear();
        this.correlationIdGenerator.set(0);
        this.deliveredItems.set(0L);
        this.erroredItems.set(0L);
        this.deliveredContainers.set(0L);
        this.erroredContainers.set(0L);
        super.channelUnregistered(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.queue.removeAndWriteAll();
        this.timer.stop();
        this.scheduledTimeouts.clear();
        this.sentButUnacknowledgedSubContainer.clear();
        this.correlationToParentContainer.clear();
        this.containerCorrelationIdMap.clear();
        this.responsesToBeDelivered.clear();
        this.correlationIdGenerator.set(0);
        this.deliveredItems.set(0L);
        this.erroredItems.set(0L);
        this.deliveredContainers.set(0L);
        this.erroredContainers.set(0L);
        super.channelInactive(ctx);
    }

    protected void tryFinish(Integer currentTdpu, InternalPlcResponse msg, CompletableFuture<InternalPlcResponse> originalResponseFuture) {
        this.deliveredItems.incrementAndGet();
        PlcRequestContainer subPlcRequestContainer = (PlcRequestContainer)this.sentButUnacknowledgedSubContainer.remove(currentTdpu);
        LOGGER.info("{} got acknowledged", (Object)subPlcRequestContainer);
        PlcRequestContainer originalPlcRequestContainer = (PlcRequestContainer)this.correlationToParentContainer.remove(currentTdpu);
        if (originalPlcRequestContainer == null) {
            LOGGER.warn("Unrelated package received {}", (Object)msg);
            return;
        }
        Queue correlatedResponseItems = this.responsesToBeDelivered.computeIfAbsent(originalPlcRequestContainer, ignore -> new ConcurrentLinkedQueue());
        correlatedResponseItems.add(msg);
        Set integers = (Set)this.containerCorrelationIdMap.get(originalPlcRequestContainer);
        integers.remove(currentTdpu);
        if (integers.isEmpty()) {
            InternalPlcResponse plcResponse;
            this.deliveredContainers.incrementAndGet();
            Timeout timeout = (Timeout)this.scheduledTimeouts.remove(originalPlcRequestContainer);
            if (timeout != null) {
                timeout.cancel();
            }
            if (originalPlcRequestContainer.getRequest() instanceof InternalPlcReadRequest) {
                InternalPlcReadRequest internalPlcReadRequest = (InternalPlcReadRequest)originalPlcRequestContainer.getRequest();
                HashMap<String, Pair<PlcResponseCode, BaseDefaultFieldItem>> fields = new HashMap<String, Pair<PlcResponseCode, BaseDefaultFieldItem>>();
                correlatedResponseItems.stream().map(InternalPlcReadResponse.class::cast).map(InternalPlcReadResponse::getValues).forEach(stringPairMap -> stringPairMap.forEach(fields::put));
                plcResponse = new DefaultPlcReadResponse(internalPlcReadRequest, fields);
            } else if (originalPlcRequestContainer.getRequest() instanceof InternalPlcWriteRequest) {
                InternalPlcWriteRequest internalPlcWriteRequest = (InternalPlcWriteRequest)originalPlcRequestContainer.getRequest();
                HashMap<String, PlcResponseCode> values = new HashMap<String, PlcResponseCode>();
                correlatedResponseItems.stream().map(InternalPlcWriteResponse.class::cast).map(InternalPlcWriteResponse::getValues).forEach(stringPairMap -> stringPairMap.forEach(values::put));
                plcResponse = new DefaultPlcWriteResponse(internalPlcWriteRequest, values);
            } else if (originalPlcRequestContainer.getRequest() instanceof InternalPlcSubscriptionRequest) {
                InternalPlcSubscriptionRequest internalPlcSubscriptionRequest = (InternalPlcSubscriptionRequest)originalPlcRequestContainer.getRequest();
                HashMap<String, Pair<PlcResponseCode, PlcSubscriptionHandle>> fields = new HashMap<String, Pair<PlcResponseCode, PlcSubscriptionHandle>>();
                correlatedResponseItems.stream().map(InternalPlcSubscriptionResponse.class::cast).map(InternalPlcSubscriptionResponse::getValues).forEach(stringPairMap -> stringPairMap.forEach(fields::put));
                plcResponse = new DefaultPlcSubscriptionResponse(internalPlcSubscriptionRequest, fields);
            } else if (originalPlcRequestContainer.getRequest() instanceof InternalPlcUnsubscriptionRequest) {
                InternalPlcUnsubscriptionRequest internalPlcUnsubscriptionRequest = (InternalPlcUnsubscriptionRequest)originalPlcRequestContainer.getRequest();
                plcResponse = new DefaultPlcUnsubscriptionResponse(internalPlcUnsubscriptionRequest);
            } else {
                this.errored(currentTdpu, (Throwable)new PlcProtocolException("Unknown type detected " + originalPlcRequestContainer.getRequest().getClass()), originalResponseFuture);
                return;
            }
            this.responsesToBeDelivered.remove(originalPlcRequestContainer);
            this.containerCorrelationIdMap.remove(originalPlcRequestContainer);
            originalResponseFuture.complete(plcResponse);
        }
    }

    protected void errored(Integer currentTdpu, Throwable throwable, CompletableFuture<InternalPlcResponse> originalResponseFuture) {
        this.erroredItems.incrementAndGet();
        PlcRequestContainer subPlcRequestContainer = (PlcRequestContainer)this.sentButUnacknowledgedSubContainer.remove(currentTdpu);
        LOGGER.info("{} got errored", (Object)subPlcRequestContainer);
        PlcRequestContainer originalPlcRequestContainer = (PlcRequestContainer)this.correlationToParentContainer.remove(currentTdpu);
        if (originalPlcRequestContainer == null) {
            LOGGER.warn("Unrelated error received tdpu:{}", (Object)currentTdpu, (Object)throwable);
        } else {
            this.erroredContainers.incrementAndGet();
            Timeout timeout = (Timeout)this.scheduledTimeouts.remove(originalPlcRequestContainer);
            if (timeout != null) {
                timeout.cancel();
            }
            this.responsesToBeDelivered.remove(originalPlcRequestContainer);
            Set tdpus = (Set)this.containerCorrelationIdMap.remove(originalPlcRequestContainer);
            if (tdpus != null) {
                tdpus.forEach(tdpu -> {
                    this.sentButUnacknowledgedSubContainer.remove(tdpu);
                    this.correlationToParentContainer.remove(tdpu);
                });
            }
            LOGGER.warn("PlcRequestContainer {} and correlationId {} failed ", new Object[]{this.correlationToParentContainer, currentTdpu, throwable});
            originalResponseFuture.completeExceptionally(throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof PlcRequestContainer) {
            PlcRequestContainer in = (PlcRequestContainer)msg;
            Set tdpus = this.containerCorrelationIdMap.computeIfAbsent(in, plcRequestContainer -> ConcurrentHashMap.newKeySet());
            Timeout timeout = this.timer.newTimeout(timeout_ -> this.handleTimeout(timeout_, in, tdpus, System.nanoTime()), this.defaultReceiveTimeout, TimeUnit.MILLISECONDS);
            this.scheduledTimeouts.put(in, timeout);
            PromiseCombiner promiseCombiner = new PromiseCombiner();
            Object request = in.getRequest();
            if (request instanceof InternalPlcFieldRequest && (this.splitConfig.splitRead || this.splitConfig.splitWrite || this.splitConfig.splitSubscription)) {
                InternalPlcFieldRequest internalPlcFieldRequest = (InternalPlcFieldRequest)request;
                if (internalPlcFieldRequest instanceof InternalPlcReadRequest && this.splitConfig.splitRead) {
                    InternalPlcReadRequest internalPlcReadRequest = (InternalPlcReadRequest)internalPlcFieldRequest;
                    internalPlcReadRequest.getNamedFields().forEach(field -> {
                        DefaultChannelPromise subPromise = new DefaultChannelPromise(promise.channel());
                        Integer tdpu = this.correlationIdGenerator.getAndIncrement();
                        CompletableFuture correlatedCompletableFuture = new CompletableFuture();
                        ((CompletableFuture)correlatedCompletableFuture.thenApply(InternalPlcResponse.class::cast)).whenComplete((internalPlcResponse, throwable) -> {
                            if (throwable != null) {
                                this.errored(tdpu, (Throwable)throwable, in.getResponseFuture());
                            } else {
                                this.tryFinish(tdpu, (InternalPlcResponse)internalPlcResponse, in.getResponseFuture());
                            }
                        });
                        PlcRequestContainer correlatedPlcRequestContainer = new PlcRequestContainer(CorrelatedPlcReadRequest.of(this.reader, (Pair<String, PlcField>)field, tdpu), correlatedCompletableFuture);
                        this.correlationToParentContainer.put(tdpu, in);
                        this.queue.add(correlatedPlcRequestContainer, (ChannelPromise)subPromise);
                        if (!tdpus.add(tdpu)) {
                            throw new IllegalStateException("AtomicInteger should not create duplicated ids: " + tdpu);
                        }
                        promiseCombiner.add((Future)subPromise);
                    });
                } else if (internalPlcFieldRequest instanceof InternalPlcWriteRequest && this.splitConfig.splitWrite) {
                    InternalPlcWriteRequest internalPlcWriteRequest = (InternalPlcWriteRequest)((Object)internalPlcFieldRequest);
                    internalPlcWriteRequest.getNamedFieldTriples().forEach(fieldItemTriple -> {
                        DefaultChannelPromise subPromise = new DefaultChannelPromise(promise.channel());
                        Integer tdpu = this.correlationIdGenerator.getAndIncrement();
                        CompletionStage correlatedCompletableFuture = ((CompletableFuture)new CompletableFuture().thenApply(InternalPlcResponse.class::cast)).whenComplete((internalPlcResponse, throwable) -> {
                            if (throwable != null) {
                                this.errored(tdpu, (Throwable)throwable, in.getResponseFuture());
                            } else {
                                this.tryFinish(tdpu, (InternalPlcResponse)internalPlcResponse, in.getResponseFuture());
                            }
                        });
                        PlcRequestContainer correlatedPlcRequestContainer = new PlcRequestContainer(CorrelatedPlcWriteRequest.of(this.writer, (Triple<String, PlcField, BaseDefaultFieldItem>)fieldItemTriple, tdpu), correlatedCompletableFuture);
                        this.correlationToParentContainer.put(tdpu, in);
                        this.queue.add(correlatedPlcRequestContainer, (ChannelPromise)subPromise);
                        if (!tdpus.add(tdpu)) {
                            throw new IllegalStateException("AtomicInteger should not create duplicated ids: " + tdpu);
                        }
                        promiseCombiner.add((Future)subPromise);
                    });
                } else {
                    if (!(internalPlcFieldRequest instanceof InternalPlcSubscriptionRequest) || !this.splitConfig.splitSubscription) throw new PlcProtocolException("Unmapped request type " + request.getClass());
                    InternalPlcSubscriptionRequest internalPlcSubscriptionRequest = (InternalPlcSubscriptionRequest)internalPlcFieldRequest;
                    internalPlcSubscriptionRequest.getNamedSubscriptionFields().forEach(field -> {
                        DefaultChannelPromise subPromise = new DefaultChannelPromise(promise.channel());
                        Integer tdpu = this.correlationIdGenerator.getAndIncrement();
                        CompletableFuture correlatedCompletableFuture = new CompletableFuture();
                        ((CompletableFuture)correlatedCompletableFuture.thenApply(InternalPlcResponse.class::cast)).whenComplete((internalPlcResponse, throwable) -> {
                            if (throwable != null) {
                                this.errored(tdpu, (Throwable)throwable, in.getResponseFuture());
                            } else {
                                this.tryFinish(tdpu, (InternalPlcResponse)internalPlcResponse, in.getResponseFuture());
                            }
                        });
                        PlcRequestContainer correlatedPlcRequestContainer = new PlcRequestContainer(CorrelatedPlcSubscriptionRequest.of(this.subscriber, (Pair<String, SubscriptionPlcField>)field, tdpu), correlatedCompletableFuture);
                        this.correlationToParentContainer.put(tdpu, in);
                        this.queue.add(correlatedPlcRequestContainer, (ChannelPromise)subPromise);
                        if (!tdpus.add(tdpu)) {
                            throw new IllegalStateException("AtomicInteger should not create duplicated ids: " + tdpu);
                        }
                        promiseCombiner.add((Future)subPromise);
                    });
                }
            } else if (request instanceof InternalPlcUnsubscriptionRequest && this.splitConfig.splitUnsubscription) {
                InternalPlcUnsubscriptionRequest internalPlcUnsubscriptionRequest = (InternalPlcUnsubscriptionRequest)request;
                internalPlcUnsubscriptionRequest.getInternalPlcSubscriptionHandles().forEach(handle -> {
                    DefaultChannelPromise subPromise = new DefaultChannelPromise(promise.channel());
                    Integer tdpu = this.correlationIdGenerator.getAndIncrement();
                    CompletableFuture correlatedCompletableFuture = new CompletableFuture();
                    ((CompletableFuture)correlatedCompletableFuture.thenApply(InternalPlcResponse.class::cast)).whenComplete((internalPlcResponse, throwable) -> {
                        if (throwable != null) {
                            this.errored(tdpu, (Throwable)throwable, in.getResponseFuture());
                        } else {
                            this.tryFinish(tdpu, (InternalPlcResponse)internalPlcResponse, in.getResponseFuture());
                        }
                    });
                    PlcRequestContainer correlatedPlcRequestContainer = new PlcRequestContainer(CorrelatedPlcUnsubscriptionRequest.of(this.subscriber, handle, tdpu), correlatedCompletableFuture);
                    this.correlationToParentContainer.put(tdpu, in);
                    this.queue.add(correlatedPlcRequestContainer, (ChannelPromise)subPromise);
                    if (!tdpus.add(tdpu)) {
                        throw new IllegalStateException("AtomicInteger should not create duplicated ids: " + tdpu);
                    }
                    promiseCombiner.add((Future)subPromise);
                });
            } else {
                DefaultChannelPromise subPromise = new DefaultChannelPromise(promise.channel());
                this.queue.add(msg, (ChannelPromise)subPromise);
                promiseCombiner.add((Future)subPromise);
            }
            promiseCombiner.finish((Promise)promise);
            this.trySendingMessages(ctx);
            return;
        } else {
            super.write(ctx, msg, promise);
        }
    }

    protected synchronized void trySendingMessages(ChannelHandlerContext ctx) {
        while (this.queue.size() > 0) {
            PlcRequestContainer currentItem = (PlcRequestContainer)this.queue.current();
            Object request = currentItem.getRequest();
            try {
                ChannelFuture channelFuture = this.queue.removeAndWrite();
                ctx.flush();
                if (channelFuture == null) {
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("Error sending more queues messages", (Throwable)e);
                ctx.fireExceptionCaught((Throwable)e);
            }
            if (!(request instanceof CorrelatedPlcRequest)) continue;
            CorrelatedPlcRequest correlatedPlcRequest = (CorrelatedPlcRequest)request;
            this.sentButUnacknowledgedSubContainer.put(correlatedPlcRequest.getTdpu(), currentItem);
            LOGGER.debug("container with id {}\u00a0sent: ", (Object)correlatedPlcRequest.getTdpu(), (Object)currentItem);
        }
        ctx.flush();
    }

    private void handleTimeout(Timeout timeout, PlcRequestContainer<InternalPlcRequest, InternalPlcResponse> in, Set<Integer> tdpus, long scheduledAt) {
        if (timeout.isCancelled()) {
            LOGGER.debug("container {} with timeout {} got canceled", in, (Object)timeout);
            return;
        }
        LOGGER.warn("container {} timed out:{}", in, (Object)timeout);
        this.erroredContainers.incrementAndGet();
        this.responsesToBeDelivered.remove(in);
        this.containerCorrelationIdMap.remove(in);
        tdpus.forEach(tdpu -> {
            this.erroredItems.incrementAndGet();
            this.sentButUnacknowledgedSubContainer.remove(tdpu);
            this.correlationToParentContainer.remove(tdpu);
        });
        in.getResponseFuture().completeExceptionally((Throwable)new PlcTimeoutException(System.nanoTime() - scheduledAt));
    }

    public Map<String, Number> getStatistics() {
        HashMap<String, Number> statistics = new HashMap<String, Number>();
        statistics.put("queue", this.queue.size());
        statistics.put("sentButUnacknowledgedSubContainer", this.sentButUnacknowledgedSubContainer.size());
        statistics.put("correlationToParentContainer", this.correlationToParentContainer.size());
        statistics.put("containerCorrelationIdMap", this.containerCorrelationIdMap.size());
        statistics.put("responsesToBeDelivered", this.responsesToBeDelivered.size());
        statistics.put("correlationIdGenerator", this.correlationIdGenerator.get());
        statistics.put("deliveredItems", this.deliveredItems.get());
        statistics.put("erroredItems", this.erroredItems.get());
        statistics.put("deliveredContainers", this.deliveredContainers.get());
        statistics.put("erroredContainers", this.erroredContainers.get());
        return statistics;
    }

    public static class SplitConfig {
        private final boolean splitRead;
        private final boolean splitWrite;
        private final boolean splitSubscription;
        private final boolean splitUnsubscription;

        public SplitConfig() {
            this.splitRead = true;
            this.splitWrite = true;
            this.splitSubscription = true;
            this.splitUnsubscription = true;
        }

        private SplitConfig(boolean splitRead, boolean splitWrite, boolean splitSubscription, boolean splitUnsubscription) {
            this.splitRead = splitRead;
            this.splitWrite = splitWrite;
            this.splitSubscription = splitSubscription;
            this.splitUnsubscription = splitUnsubscription;
        }

        public static SplitConfigBuilder builder() {
            return new SplitConfigBuilder();
        }

        public static class SplitConfigBuilder {
            private boolean splitRead = true;
            private boolean splitWrite = true;
            private boolean splitSubscription = true;
            private boolean splitUnsubscription = true;

            public SplitConfigBuilder splitRead() {
                this.splitRead = true;
                return this;
            }

            public SplitConfigBuilder dontSplitRead() {
                this.splitRead = false;
                return this;
            }

            public SplitConfigBuilder splitWrite() {
                this.splitWrite = true;
                return this;
            }

            public SplitConfigBuilder dontSplitWrite() {
                this.splitWrite = false;
                return this;
            }

            public SplitConfigBuilder splitSubscribe() {
                this.splitSubscription = true;
                return this;
            }

            public SplitConfigBuilder dontSplitSubscribe() {
                this.splitSubscription = false;
                return this;
            }

            public SplitConfigBuilder splitUnsubscribe() {
                this.splitUnsubscription = true;
                return this;
            }

            public SplitConfigBuilder dontSplitUnsubscribe() {
                this.splitUnsubscription = false;
                return this;
            }

            public SplitConfig build() {
                return new SplitConfig(this.splitRead, this.splitWrite, this.splitSubscription, this.splitUnsubscription);
            }
        }
    }

    protected static class CorrelatedPlcUnsubscriptionRequest
    extends DefaultPlcUnsubscriptionRequest
    implements CorrelatedPlcRequest {
        protected final int tdpu;

        protected CorrelatedPlcUnsubscriptionRequest(PlcSubscriber subscriber, LinkedList<InternalPlcSubscriptionHandle> subscriptionHandles, int tdpu) {
            super(subscriber, subscriptionHandles);
            this.tdpu = tdpu;
        }

        protected static CorrelatedPlcUnsubscriptionRequest of(PlcSubscriber subscriber, InternalPlcSubscriptionHandle subscriptionHandle, int tdpu) {
            LinkedList<InternalPlcSubscriptionHandle> list = new LinkedList<InternalPlcSubscriptionHandle>();
            list.add(subscriptionHandle);
            return new CorrelatedPlcUnsubscriptionRequest(subscriber, list, tdpu);
        }

        @Override
        public int getTdpu() {
            return this.tdpu;
        }
    }

    protected static class CorrelatedPlcSubscriptionRequest
    extends DefaultPlcSubscriptionRequest
    implements CorrelatedPlcRequest {
        protected final int tdpu;

        protected CorrelatedPlcSubscriptionRequest(PlcSubscriber subscriber, LinkedHashMap<String, SubscriptionPlcField> fields, int tdpu) {
            super(subscriber, fields);
            this.tdpu = tdpu;
        }

        protected static CorrelatedPlcSubscriptionRequest of(PlcSubscriber subscriber, Pair<String, SubscriptionPlcField> stringPlcFieldPair, int tdpu) {
            LinkedHashMap<String, SubscriptionPlcField> fields = new LinkedHashMap<String, SubscriptionPlcField>();
            fields.put((String)stringPlcFieldPair.getKey(), (SubscriptionPlcField)stringPlcFieldPair.getValue());
            return new CorrelatedPlcSubscriptionRequest(subscriber, fields, tdpu);
        }

        @Override
        public int getTdpu() {
            return this.tdpu;
        }
    }

    protected static class CorrelatedPlcWriteRequest
    extends DefaultPlcWriteRequest
    implements CorrelatedPlcRequest {
        private final int tdpu;

        public CorrelatedPlcWriteRequest(PlcWriter writer, LinkedHashMap<String, Pair<PlcField, BaseDefaultFieldItem>> fields, int tdpu) {
            super(writer, fields);
            this.tdpu = tdpu;
        }

        public static CorrelatedPlcWriteRequest of(PlcWriter writer, Triple<String, PlcField, BaseDefaultFieldItem> fieldItemTriple, int tdpu) {
            LinkedHashMap<String, Pair<PlcField, BaseDefaultFieldItem>> fields = new LinkedHashMap<String, Pair<PlcField, BaseDefaultFieldItem>>();
            fields.put((String)fieldItemTriple.getLeft(), (Pair<PlcField, BaseDefaultFieldItem>)Pair.of((Object)fieldItemTriple.getMiddle(), (Object)fieldItemTriple.getRight()));
            return new CorrelatedPlcWriteRequest(writer, fields, tdpu);
        }

        @Override
        public int getTdpu() {
            return this.tdpu;
        }
    }

    protected static class CorrelatedPlcReadRequest
    extends DefaultPlcReadRequest
    implements CorrelatedPlcRequest {
        protected final int tdpu;

        protected CorrelatedPlcReadRequest(PlcReader reader, LinkedHashMap<String, PlcField> fields, int tdpu) {
            super(reader, fields);
            this.tdpu = tdpu;
        }

        protected static CorrelatedPlcReadRequest of(PlcReader reader, Pair<String, PlcField> stringPlcFieldPair, int tdpu) {
            LinkedHashMap<String, PlcField> fields = new LinkedHashMap<String, PlcField>();
            fields.put((String)stringPlcFieldPair.getKey(), (PlcField)stringPlcFieldPair.getValue());
            return new CorrelatedPlcReadRequest(reader, fields, tdpu);
        }

        @Override
        public int getTdpu() {
            return this.tdpu;
        }
    }

    protected static interface CorrelatedPlcRequest
    extends InternalPlcRequest {
        public int getTdpu();
    }
}

