/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultLongFieldItem
extends BaseDefaultFieldItem<Long> {
    public DefaultLongFieldItem(Long ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return (Long)this.getValue(index) != 0L;
    }

    @Override
    public boolean isValidByte(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= 127L && value >= -128L;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return ((Long)this.getValue(index)).byteValue();
    }

    @Override
    public boolean isValidShort(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= 32767L && value >= -32768L;
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((Long)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        Long value = (Long)this.getValue(index);
        return value != null && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE;
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return ((Long)this.getValue(index)).intValue();
    }

    @Override
    public boolean isValidLong(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return (Long)this.getValue(index);
    }

    @Override
    public boolean isValidBigInteger(int index) {
        return this.isValidLong(index);
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return BigInteger.valueOf((Long)this.getValue(index));
    }

    @Override
    public boolean isValidFloat(int index) {
        return this.isValidLong(index);
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((Long)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.isValidLong(index);
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return ((Long)this.getValue(index)).doubleValue();
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.isValidLong(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return new BigDecimal((Long)this.getValue(index));
    }
}

