/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultDoubleFieldItem
extends BaseDefaultFieldItem<Double> {
    public DefaultDoubleFieldItem(Double ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return (Double)this.getValue(index) != 0.0;
    }

    @Override
    public boolean isValidByte(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 127.0 && value >= -128.0;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return ((Double)this.getValue(index)).byteValue();
    }

    @Override
    public boolean isValidShort(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 32767.0 && value >= -32768.0;
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((Double)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 2.147483647E9 && value >= -2.147483648E9;
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return ((Double)this.getValue(index)).intValue();
    }

    @Override
    public boolean isValidLong(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 9.223372036854776E18 && value >= -9.223372036854776E18;
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return ((Double)this.getValue(index)).longValue();
    }

    @Override
    public boolean isValidBigInteger(int index) {
        Double value = (Double)this.getValue(index);
        return value != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return BigInteger.valueOf(((Double)this.getValue(index)).longValue());
    }

    @Override
    public boolean isValidFloat(int index) {
        Double value = (Double)this.getValue(index);
        return value != null && value <= 3.4028234663852886E38 && value >= -3.4028234663852886E38;
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((Double)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return (Double)this.getValue(index);
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return new BigDecimal((Double)this.getValue(index));
    }
}

