/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.base.messages.items;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.plc4x.java.api.exceptions.PlcIncompatibleDatatypeException;
import org.apache.plc4x.java.base.messages.items.BaseDefaultFieldItem;

public class DefaultBigIntegerFieldItem
extends BaseDefaultFieldItem<BigInteger> {
    public DefaultBigIntegerFieldItem(BigInteger ... values) {
        super(values);
    }

    @Override
    public Object getObject(int index) {
        return this.getValue(index);
    }

    @Override
    public boolean isValidBoolean(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public Boolean getBoolean(int index) {
        if (!this.isValidBoolean(index)) {
            throw new PlcIncompatibleDatatypeException(Boolean.class, index);
        }
        return ((BigInteger)this.getValue(index)).compareTo(BigInteger.ZERO) == 0;
    }

    @Override
    public boolean isValidByte(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(127L)) <= 0 && value.compareTo(BigInteger.valueOf(-128L)) >= 0;
    }

    @Override
    public Byte getByte(int index) {
        if (!this.isValidByte(index)) {
            throw new PlcIncompatibleDatatypeException(Byte.class, index);
        }
        return ((BigInteger)this.getValue(index)).byteValue();
    }

    @Override
    public boolean isValidShort(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(32767L)) <= 0 && value.compareTo(BigInteger.valueOf(-32768L)) >= 0;
    }

    @Override
    public Short getShort(int index) {
        if (!this.isValidShort(index)) {
            throw new PlcIncompatibleDatatypeException(Short.class, index);
        }
        return ((BigInteger)this.getValue(index)).shortValue();
    }

    @Override
    public boolean isValidInteger(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0 && value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) >= 0;
    }

    @Override
    public Integer getInteger(int index) {
        if (!this.isValidInteger(index)) {
            throw new PlcIncompatibleDatatypeException(Integer.class, index);
        }
        return ((BigInteger)this.getValue(index)).intValue();
    }

    @Override
    public boolean isValidLong(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        return value != null && value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 && value.compareTo(BigInteger.valueOf(Long.MIN_VALUE)) >= 0;
    }

    @Override
    public Long getLong(int index) {
        if (!this.isValidLong(index)) {
            throw new PlcIncompatibleDatatypeException(Long.class, index);
        }
        return ((BigInteger)this.getValue(index)).longValue();
    }

    @Override
    public boolean isValidBigInteger(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigInteger getBigInteger(int index) {
        if (!this.isValidBigInteger(index)) {
            throw new PlcIncompatibleDatatypeException(BigInteger.class, index);
        }
        return (BigInteger)this.getValue(index);
    }

    @Override
    public boolean isValidFloat(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        if (value == null) {
            return false;
        }
        BigDecimal decimalValue = new BigDecimal(value);
        return decimalValue.compareTo(BigDecimal.valueOf(3.4028234663852886E38)) <= 0 && decimalValue.compareTo(BigDecimal.valueOf(-3.4028234663852886E38)) >= 0;
    }

    @Override
    public Float getFloat(int index) {
        if (!this.isValidFloat(index)) {
            throw new PlcIncompatibleDatatypeException(Float.class, index);
        }
        return Float.valueOf(((BigInteger)this.getValue(index)).floatValue());
    }

    @Override
    public boolean isValidDouble(int index) {
        BigInteger value = (BigInteger)this.getValue(index);
        if (value == null) {
            return false;
        }
        BigDecimal decimalValue = new BigDecimal(value);
        return decimalValue.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) <= 0 && decimalValue.compareTo(BigDecimal.valueOf(-1.7976931348623157E308)) >= 0;
    }

    @Override
    public Double getDouble(int index) {
        if (!this.isValidDouble(index)) {
            throw new PlcIncompatibleDatatypeException(Double.class, index);
        }
        return ((BigInteger)this.getValue(index)).doubleValue();
    }

    @Override
    public boolean isValidBigDecimal(int index) {
        return this.getValue(index) != null;
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        if (!this.isValidBigDecimal(index)) {
            throw new PlcIncompatibleDatatypeException(BigDecimal.class, index);
        }
        return new BigDecimal((BigInteger)this.getValue(index));
    }
}

